(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    458153,       9525]
NotebookOptionsPosition[    444155,       9080]
NotebookOutlinePosition[    444574,       9096]
CellTagsIndexPosition[    444531,       9093]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 2", "Title",
 Editable->False,
 CellChangeTimes->{{3.3908915151062975`*^9, 3.3908915166785583`*^9}}],

Cell["Statistical Tools and Terminology", "Subtitle",
 Editable->False,
 CellChangeTimes->{{3.41198906255157*^9, 3.41198907047296*^9}}],

Cell["\[Copyright]W.W.Sampson, Manchester, 2008", "Subsubtitle",
 Editable->False,
 CellChangeTimes->{{3.412935407213834*^9, 3.412935418490048*^9}}],

Cell[CellGroupData[{

Cell["2.2 Discrete and Continuous Random Variables", "Section",
 Editable->False,
 CellChangeTimes->{{3.4119907212666845`*^9, 3.411990735967824*^9}}],

Cell[CellGroupData[{

Cell["2.2.1 Characterising Statistics", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.390891520273728*^9, 3.3908915270434628`*^9}, {
  3.4119891162888403`*^9, 3.4119891181114607`*^9}}],

Cell[CellGroupData[{

Cell["Generating and Characterising pseudorandom Data", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4119914383678255`*^9, 3.411991456934523*^9}, {
  3.4119915240610466`*^9, 3.4119915374803424`*^9}}],

Cell[TextData[{
 "Here we generate the simulated dice rolls using the command ",
 StyleBox["RandomInteger", "Input"],
 " to generate pairs of pseudorandom integers between 1 and 6 inclusive."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411989228079587*^9, 3.4119892528752413`*^9}, {
  3.4119904382697554`*^9, 3.4119904934090414`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"pairs", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"20", ",", "2"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.390886222746258*^9, 3.3908862282441635`*^9}, 
   3.390886395134139*^9, {3.3908864817186413`*^9, 3.39088649835256*^9}, {
   3.390886553581976*^9, 3.390886561843856*^9}, {3.3908893980320945`*^9, 
   3.39088943707824*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3908910229385953`*^9, 3.3909024487280736`*^9, 
  3.3909070327896304`*^9, 3.3911510311620145`*^9, 3.404729877995875*^9}]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["Part", "Input"],
 " allows us to extract elements from a list by their location in that list:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119892718325005`*^9, 3.4119893113693523`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Part", "[", 
  RowBox[{"pairs", ",", " ", "4"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"pairs", "[", 
  RowBox[{"[", "8", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.390889443036808*^9, 3.3908894711572433`*^9}, {
   3.390889874106656*^9, 3.3908898798248787`*^9}, {3.390889939620861*^9, 
   3.390889957256219*^9}, {3.390896102292347*^9, 3.3908961052265663`*^9}, 
   3.390896158282858*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.3908961586634045`*^9, 3.390902448988448*^9, 
  3.390907032979904*^9, 3.3911511323575263`*^9, 3.404729878058375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.3908961586634045`*^9, 3.390902448988448*^9, 
  3.390907032979904*^9, 3.3911511323575263`*^9, 3.404729878074*^9}]
}, Open  ]],

Cell[TextData[{
 "We sum each sublist using the command ",
 StyleBox["Total", "Input"],
 " within a ",
 StyleBox["Table", "Input"],
 " command:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119893494140577`*^9, 3.411989375040907*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rolls", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"pairs", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", " ", "20"}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8", ",", "6", ",", "3", ",", "4", ",", "2", ",", "10", ",", "4", ",", "9", 
   ",", "7", ",", "8", ",", "7", ",", "8", ",", "4", ",", "11", ",", "11", 
   ",", "5", ",", "5", ",", "4", ",", "6", ",", "6"}], "}"}]], "Output",
 CellChangeTimes->{3.3908982125167007`*^9, 3.390902449058549*^9, 
  3.3909070330700336`*^9, 3.3911511383361235`*^9, 3.40472987810525*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean of the entries in our list is calculated using the command ",
 StyleBox["Mean", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41198940845896*^9, 3.4119894336952477`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "rolls", "]"}]], "Input"],

Cell[BoxData[
 FractionBox["32", "5"]], "Output",
 CellChangeTimes->{3.3908994546027327`*^9, 3.390902449098606*^9, 
  3.390907033110091*^9, 3.391151152145981*^9, 3.4047298781365*^9}]
}, Open  ]],

Cell[TextData[{
 "We convert the result to numerical precision using ",
 StyleBox["N", "Input"],
 ". The argument ",
 StyleBox["%", "Input"],
 " represents the last output:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119894557870145`*^9, 3.411989518146683*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.390902473443613*^9, 3.390902474675384*^9}}],

Cell[BoxData["6.4`"], "Output",
 CellChangeTimes->{3.3909024756067233`*^9, 3.390907033160163*^9, 
  3.3911511544192495`*^9, 3.40472987816775*^9}]
}, Open  ]],

Cell["We compute the variance explicitly using Equation 2.3:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119895392670527`*^9, 3.411989583360456*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"rolls", " ", "-", " ", 
      RowBox[{"Mean", "[", "rolls", "]"}]}], ")"}], "^", "2"}], "]"}], "/", 
  "19"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.3909066872227297`*^9, 3.3909067123488593`*^9}, {
  3.390907014303048*^9, 3.3909070161156545`*^9}}],

Cell[BoxData[
 FractionBox["644", "95"]], "Output",
 CellChangeTimes->{3.3909069963772717`*^9, 3.390907033210235*^9, 
  3.391151165515205*^9, 3.404729878199*^9}],

Cell[BoxData["6.778947368421052`"], "Output",
 CellChangeTimes->{3.3909069963772717`*^9, 3.390907033210235*^9, 
  3.391151165515205*^9, 3.404729878199*^9}]
}, Open  ]],

Cell[TextData[{
 "Equation 2.3 is invoked directly using the command ",
 StyleBox["Variance", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119895939356623`*^9, 3.4119896135438576`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "rolls", "]"}]], "Input",
 CellChangeTimes->{{3.390907020281645*^9, 3.3909070264304867`*^9}}],

Cell[BoxData[
 FractionBox["644", "95"]], "Output",
 CellChangeTimes->{3.390907033280336*^9, 3.3911511676082144`*^9, 
  3.4047298782615*^9}]
}, Open  ]],

Cell["\<\
Similarly, we obtain the standard deviation, as given by Equation 2.5:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119896348645153`*^9, 3.41198965381176*^9}, {
  3.4119897029724493`*^9, 3.4119897077593327`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"StandardDeviation", "[", "rolls", "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.390907312832312*^9, 3.3909073208838897`*^9}, {
  3.3911511751690865`*^9, 3.391151177462384*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["161", "95"]]}]], "Output",
 CellChangeTimes->{3.390907417733152*^9, 3.3911511787241983`*^9, 
  3.404729878277125*^9}],

Cell[BoxData["2.603641175051019`"], "Output",
 CellChangeTimes->{3.390907417733152*^9, 3.3911511787241983`*^9, 
  3.404729878277125*^9}]
}, Open  ]],

Cell[TextData[{
 "The expression ",
 StyleBox["TrueQ", "Input"],
 " test if the expression contained within the square brackets is true of \
false. Here we confirm that the standard deviation is the square root of the \
variance:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411989739234592*^9, 3.411989766704091*^9}, {
  3.4119898928655024`*^9, 3.411989937169208*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "rolls", "]"}], " ", "\[Equal]", " ", 
   SqrtBox[
    RowBox[{"Variance", "[", "rolls", "]"}]]}], "]"}]], "Input",
 CellChangeTimes->{{3.3909075115280223`*^9, 3.3909075266497664`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.3909075272105727`*^9, 3.3909075497229443`*^9}, 
   3.3911512252911587`*^9, 3.404729878308375*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows many different notations to be used that are all equivalent:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119899521207075`*^9, 3.411989990275571*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sqrt", "[", 
  RowBox[{"Variance", "[", "rolls", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Variance", "[", "rolls", "]"}], "^", 
  RowBox[{"(", 
   RowBox[{"1", "/", "2"}], ")"}]}], "\[IndentingNewLine]", 
 SuperscriptBox[
  RowBox[{"Variance", "[", "rolls", "]"}], 
  RowBox[{"1", "/", "2"}]], "\[IndentingNewLine]", 
 RowBox[{"Power", "[", 
  RowBox[{
   RowBox[{"Variance", "[", "rolls", "]"}], ",", " ", 
   RowBox[{"1", "/", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.3909081242590866`*^9, {3.3909083664373217`*^9, 3.3909083959898157`*^9}, {
   3.390908494932088*^9, 3.3909084951624193`*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["161", "95"]]}]], "Output",
 CellChangeTimes->{3.404729878339625*^9}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["161", "95"]]}]], "Output",
 CellChangeTimes->{3.404729878339625*^9}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["161", "95"]]}]], "Output",
 CellChangeTimes->{3.404729878339625*^9}],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["161", "95"]]}]], "Output",
 CellChangeTimes->{3.40472987835525*^9}]
}, Open  ]],

Cell[TextData[{
 "We compute the median, mode and coefficient of variation in the next lines \
of code. Note the command ",
 StyleBox["Commonest", "Input"],
 " for the mode. ",
 StyleBox["Mode", "Input"],
 " has alternative uses in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411990002913744*^9, 3.4119900667655582`*^9}, {
  3.412326994965246*^9, 3.4123269969180546`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Median", "[", "rolls", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Commonest", "[", "rolls", "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Commonest", " ", "=", " ", "mode"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"CVrolls", " ", "=", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "rolls", "]"}], "/", 
   RowBox[{"Mean", "[", "rolls", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "CVrolls", "]"}]}], "Input",
 CellChangeTimes->{{3.390909994057725*^9, 3.390910135941744*^9}}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{3.3909101554998674`*^9, 3.391151269614893*^9, 
  3.4047298783865*^9}],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 CellChangeTimes->{3.3909101554998674`*^9, 3.391151269614893*^9, 
  3.404729878433375*^9}],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["805", "19"]], "16"]], "Output",
 CellChangeTimes->{3.3909101554998674`*^9, 3.391151269614893*^9, 
  3.404729878433375*^9}],

Cell[BoxData["0.4068189336017218`"], "Output",
 CellChangeTimes->{3.3909101554998674`*^9, 3.391151269614893*^9, 
  3.404729878433375*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing SeedRandom", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.390891520273728*^9, 3.3908915270434628`*^9}, {
  3.391162486644189*^9, 3.391162490609891*^9}}],

Cell[TextData[{
 "The command ",
 StyleBox["SeedRandom", "Input"],
 " rests the pseudorandom number generator. It is instructive to evaluate the \
following code with a different value of ",
 StyleBox["n", "Input"],
 " in the argument to ",
 StyleBox["SeedRandom[n]", "Input"],
 ". Also, try removing the first line of code and evaluate the remaining code \
repeatedly."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411990189231656*^9, 3.411990345676613*^9}, {
  3.4123270033973713`*^9, 3.412327004639157*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"pairs", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"20", ",", "2"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"rolls", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"pairs", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", " ", "20"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.390886222746258*^9, 3.3908862282441635`*^9}, 
   3.390886395134139*^9, {3.3908864817186413`*^9, 3.39088649835256*^9}, {
   3.390886553581976*^9, 3.390886561843856*^9}, {3.3908893980320945`*^9, 
   3.39088943707824*^9}, {3.3909111214488335`*^9, 3.3909111236019297`*^9}, 
   3.390911172131712*^9, 3.3909114141196737`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.390911420719163*^9, 3.39115132015757*^9, 
  3.404729878464625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"N", "[", 
  RowBox[{"Mean", "[", "rolls", "]"}], "]"}], "\n", 
 RowBox[{"N", "[", 
  RowBox[{"Variance", "[", "rolls", "]"}], "]"}], "\n", 
 RowBox[{"N", "[", 
  RowBox[{"StandardDeviation", "[", "rolls", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.390911201323688*^9, 3.390911222484115*^9}, 
   3.390911428680611*^9}],

Cell[BoxData["6.95`"], "Output",
 CellChangeTimes->{3.390911437973974*^9, 3.3911513796130624`*^9, 
  3.404729878495875*^9}],

Cell[BoxData["5.313157894736842`"], "Output",
 CellChangeTimes->{3.390911437973974*^9, 3.3911513796130624`*^9, 
  3.404729878495875*^9}],

Cell[BoxData["2.3050288273114594`"], "Output",
 CellChangeTimes->{3.390911437973974*^9, 3.3911513796130624`*^9, 
  3.404729878495875*^9}]
}, Open  ]],

Cell[TextData[{
 "Here we simulate the rolls of pairs of dice with two random seeds and pool \
the results using ",
 StyleBox["Join", "Input"],
 "."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119903815782366`*^9, 3.4119904217259665`*^9}}],

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pairs", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"20", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rolls1", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"pairs", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", " ", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"SeedRandom", "[", "2", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pairs", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"20", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rolls2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"pairs", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", " ", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pooledrolls", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"rolls1", ",", " ", "rolls2"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.390886222746258*^9, 3.3908862282441635`*^9}, 
   3.390886395134139*^9, {3.3908864817186413`*^9, 3.39088649835256*^9}, {
   3.390886553581976*^9, 3.390886561843856*^9}, {3.3908893980320945`*^9, 
   3.39088943707824*^9}, {3.3911517194817696`*^9, 3.391151832103712*^9}, 
   3.3911525881308255`*^9}],

Cell["\<\
The following code computes the mean, variance and standard deviation of our \
pooled data. Note that the mean is precisely the mean of our two estimates \
from the independent samples. The same is not true of the variance and the \
standard deviation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.411990544873043*^9, 3.4119906348023553`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Length", "[", "pooledrolls", "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{"Mean", "[", "pooledrolls", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{"Variance", "[", "pooledrolls", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{"StandardDeviation", "[", "pooledrolls", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3911518346673985`*^9, 3.3911518800827026`*^9}, {
  3.3911525696041856`*^9, 3.3911525867488384`*^9}}],

Cell[BoxData["40"], "Output",
 CellChangeTimes->{{3.391151863278539*^9, 3.3911518810941567`*^9}, {
   3.3911525915857935`*^9, 3.3911526083899565`*^9}, 3.404729878527125*^9}],

Cell[BoxData["6.675`"], "Output",
 CellChangeTimes->{{3.391151863278539*^9, 3.3911518810941567`*^9}, {
   3.3911525915857935`*^9, 3.3911526083899565`*^9}, 3.404729878527125*^9}],

Cell[BoxData["5.968589743589743`"], "Output",
 CellChangeTimes->{{3.391151863278539*^9, 3.3911518810941567`*^9}, {
   3.3911525915857935`*^9, 3.3911526083899565`*^9}, 3.404729878527125*^9}],

Cell[BoxData["2.44306973776635`"], "Output",
 CellChangeTimes->{{3.391151863278539*^9, 3.3911518810941567`*^9}, {
   3.3911525915857935`*^9, 3.3911526083899565`*^9}, 3.40472987854275*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evolution of Stable Statistics", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3911625039390574`*^9, 3.39116251191052*^9}, {
  3.411991514767683*^9, 3.411991517431514*^9}}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles very large lists very comfortably. We obtain a much improved \
estimate of the mean and variance using much larger samples. Here we simulate \
the rolling of a million pairs of dice and compute the mean and standard \
deviation:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119907704774466`*^9, 3.4119908641120863`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pairs", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rolls", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"pairs", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", " ", 
       RowBox[{"Length", "[", "pairs", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Mean", "[", 
  RowBox[{"N", "[", "rolls", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"N", "[", "rolls", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3911532261282206`*^9, 3.391153357617293*^9}, {
   3.39115339088513*^9, 3.391153412996925*^9}, {3.391153446935726*^9, 
   3.3911534531947265`*^9}, {3.391153503847562*^9, 3.3911535213727617`*^9}, {
   3.3911535530382943`*^9, 3.3911535656464243`*^9}, 3.3911536697861695`*^9, 
   3.391154351145917*^9, 3.3911545825887156`*^9, {3.391154746314141*^9, 
   3.39115477569639*^9}}],

Cell[BoxData["7.000888`"], "Output",
 CellChangeTimes->{3.3911545866044893`*^9, 3.3911547505402174`*^9, 
  3.391154788424693*^9, 3.404729880964625*^9}],

Cell[BoxData["2.4150066342999574`"], "Output",
 CellChangeTimes->{3.3911545866044893`*^9, 3.3911547505402174`*^9, 
  3.391154788424693*^9, 3.40472988110525*^9}]
}, Open  ]],

Cell[TextData[{
 "If we work with numerical, rather than integer, precision, then the \
computation is much more efficient as illustrated by the command ",
 StyleBox["Timing", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119908777917566`*^9, 3.4119909146747923`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"StandardDeviation", "[", "rolls", "]"}], "//", 
  "Timing"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"StandardDeviation", "[", "rolls", "]"}], "]"}], "//", 
  "Timing"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StandardDeviation", "[", 
   RowBox[{"N", "[", "rolls", "]"}], "]"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.391153592725362*^9, 3.3911536287772017`*^9}, {
  3.39115369557325*^9, 3.3911537041055183`*^9}, {3.3911545445640383`*^9, 
  3.39115454645676*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.25`", ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox[
      FractionBox["375016153", "37037"]]}], "125"]}], "}"}]], "Output",
 CellChangeTimes->{3.391153713839515*^9, 3.391155121964299*^9, 
  3.404729887527125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.344000000000001`", ",", "2.415006634300006`"}], "}"}]], "Output",\

 CellChangeTimes->{3.391153713839515*^9, 3.391155121964299*^9, 
  3.404729893949*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04699999999999882`", ",", "2.4150066342999574`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.391153713839515*^9, 3.391155121964299*^9, 
  3.404729894027125*^9}]
}, Open  ]],

Cell["\<\
We track the evolution of a stable estimate of the mean by computing it for \
samples of increasing size:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119909549426947`*^9, 3.411991002601224*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"meanrollsn", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Mean", "[", 
        RowBox[{"N", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"rolls", ",", " ", "n"}], "]"}], "]"}], "]"}]}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", " ", "100", ",", " ", "100000", ",", " ", "100"}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"meanrollsn", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<n\>\"", ",", " ", "\"\<Mean\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3911532261282206`*^9, 3.391153357617293*^9}, {
   3.39115339088513*^9, 3.391153412996925*^9}, {3.391153446935726*^9, 
   3.3911534531947265`*^9}, {3.391153503847562*^9, 3.3911535213727617`*^9}, {
   3.3911535530382943`*^9, 3.3911535875379024`*^9}, 3.3911536495971394`*^9, {
   3.3911537454649906`*^9, 3.3911537655438623`*^9}, {3.3911538337218976`*^9, 
   3.3911538394301057`*^9}, {3.391154136317008*^9, 3.3911541614531517`*^9}, {
   3.391154246755811*^9, 3.391154262678707*^9}, 3.3911542957863135`*^9, {
   3.3911543646853857`*^9, 3.3911543839831343`*^9}, {3.391154431651678*^9, 
   3.3911544353670206`*^9}, {3.391154522342085*^9, 3.391154529001661*^9}, {
   3.391155795222397*^9, 3.3911558343686867`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdWwdQVEnXxTUrBsCAAcW4ZsUAhlWPggkDoKviKiYMmMAs5hGzKAYwgSKY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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"n\"", TraditionalForm], 
    FormBox["\"Mean\"", TraditionalForm]},
  AxesOrigin->{0, 6.92},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.3911558509925904`*^9, 3.3911559412523775`*^9, 
  3.404729895199*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Similarly for the standard deviation:", "Text",
 Editable->False,
 CellChangeTimes->{{3.411991007808712*^9, 3.4119910154096413`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"stdrollsn", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"StandardDeviation", "[", 
        RowBox[{"N", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"rolls", ",", " ", "n"}], "]"}], "]"}], "]"}]}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", " ", "100", ",", " ", "100000", ",", " ", "100"}], 
      "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"stdrollsn", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<n\>\"", ",", " ", "\"\<Standard deviation\>\""}], "}"}]}]}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.3911532261282206`*^9, 3.391153357617293*^9}, {
   3.39115339088513*^9, 3.391153412996925*^9}, {3.391153446935726*^9, 
   3.3911534531947265`*^9}, {3.391153503847562*^9, 3.3911535213727617`*^9}, {
   3.3911535530382943`*^9, 3.3911535875379024`*^9}, 3.3911536495971394`*^9, {
   3.3911537454649906`*^9, 3.3911537655438623`*^9}, {3.3911538337218976`*^9, 
   3.3911538394301057`*^9}, {3.391154136317008*^9, 3.3911541614531517`*^9}, {
   3.391154246755811*^9, 3.391154262678707*^9}, 3.3911542957863135`*^9, {
   3.3911543646853857`*^9, 3.3911543839831343`*^9}, {3.391154431651678*^9, 
   3.3911544353670206`*^9}, {3.391154522342085*^9, 3.391154529001661*^9}, {
   3.391155795222397*^9, 3.3911558458151455`*^9}, {3.391155907674094*^9, 
   3.391155912120488*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxFm3dczt///1tG2SshW95UdrJ5IKOEyCYjq6zMikIRsrISEspKKJGMCpfQ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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"n\"", TraditionalForm], 
    FormBox["\"Standard deviation\"", TraditionalForm]},
  AxesOrigin->{0, 2.38},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.3911558572315617`*^9, {3.3911559194309998`*^9, 3.3911559473811903`*^9}, 
   3.404729898745875*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theoretical Determination of Characterising Statistics", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.3911625286946545`*^9, 3.391162537276995*^9}, {
  3.4119914986945715`*^9, 3.4119915113227296`*^9}}],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", distributions are objects in their own right. The following code defines \
the discrete uniform distribution on the interval ",
 StyleBox["xmin", "Input"],
 " to ",
 StyleBox["xmax", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411991566091483*^9, 3.411991628751584*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteUniformDistribution", "[", 
  RowBox[{"{", 
   RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"DiscreteUniformDistribution", "[", 
  RowBox[{"{", 
   RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}]], "Output",
 CellChangeTimes->{3.39116322017896*^9, 3.3911632535269117`*^9, 
  3.391163922458789*^9, 3.3911725575454335`*^9, 3.3911731153575277`*^9, 
  3.40472989879275*^9}]
}, Open  ]],

Cell[TextData[{
 "We obtain the probability distribution function using ",
 StyleBox["PDF", "Input"],
 ". The second argument identifies the random variable of interest, in our \
case ",
 StyleBox["x", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119916424012113`*^9, 3.411991688407365*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.3911625502256145`*^9, 3.391162597784*^9}}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "xmax", "-", "xmin"}]]], "Output",
 CellChangeTimes->{{3.3911625820013056`*^9, 3.3911625989857283`*^9}, 
   3.3911632797546253`*^9, 3.3911639226590767`*^9, 3.391172557745722*^9, 
   3.391173115627917*^9, 3.404729898824*^9}]
}, Open  ]],

Cell[TextData[{
 "The following code gives the probability distribution function that \
describes the roll of a fair six-sided die. Note that it is not defined for \
",
 StyleBox["x", "Input"],
 " < 1 or ",
 StyleBox["x ", "Input"],
 "> 6 or non-integer 1 \[LessEqual] ",
 StyleBox["x", "Input"],
 " \[LessEqual] 6."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119917063131123`*^9, 3.4119918382928896`*^9}, 
   3.412327011879568*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], "]"}], ",", " ", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"DiscreteUniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "6"}], "}"}], "]"}], ",", " ", "x"}], "]"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "8"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], "]"}], ",", " ", "2.2"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.3911625502256145`*^9, 3.391162597784*^9}, {
  3.3911626365597568`*^9, 3.391162668065059*^9}, {3.3911637898681326`*^9, 
  3.3911637901585503`*^9}, {3.3911638893812256`*^9, 3.3911639068363247`*^9}}],\


Cell[BoxData[
 FractionBox["1", "6"]], "Output",
 CellChangeTimes->{
  3.391163796878213*^9, {3.391163899986475*^9, 3.391163922719163*^9}, 
   3.3911725577957935`*^9, 3.3911731156980176`*^9, 3.40472989885525*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.391163796878213*^9, {3.391163899986475*^9, 3.391163922719163*^9}, 
   3.3911725577957935`*^9, 3.3911731156980176`*^9, 3.40472989885525*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.391163796878213*^9, {3.391163899986475*^9, 3.391163922719163*^9}, 
   3.3911725577957935`*^9, 3.3911731156980176`*^9, 3.40472989885525*^9}]
}, Open  ]],

Cell["\<\
Probability distribution functions must sum to unity over the interval on \
which they are defined:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.411991853074144*^9, 3.411991878210288*^9}, 
   3.4123270135019007`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"DiscreteUniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], ",", " ", "x"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "xmin", ",", " ", "xmax"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39116281284324*^9, 3.3911628301381087`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3911644267539296`*^9, 3.391172558436715*^9, 
  3.3911731159183345`*^9, 3.404729899199*^9}]
}, Open  ]],

Cell[TextData[{
 "For a probability distribution function ",
 StyleBox["P",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") defined on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     SubscriptBox["x", "min"], ",", " ", 
     SubscriptBox["x", "max"]}], "]"}], TraditionalForm]]],
 " the mean is given by Equation 2.8:\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["x", "_"], " ", "=", " "}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"x", "=", "xmin"}], "xmax"], 
    RowBox[{"x", " ", 
     RowBox[{"P", "(", "x", ")"}]}]}], TraditionalForm]]],
 "\n\nWe input this to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 StyleBox["Sum", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119918907182736`*^9, 3.4119919162750225`*^9}, {
   3.4119919598576913`*^9, 3.4119920571976595`*^9}, {3.411992094841789*^9, 
   3.411992161798067*^9}, 3.411992200073104*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xbar", " ", "=", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"DiscreteUniformDistribution", "[", 
        RowBox[{"{", 
         RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], ",", " ", "x"}], 
      "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "xmin", ",", " ", "xmax"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.39116281284324*^9, 3.391162842686152*^9}, {
  3.391162874281584*^9, 3.3911628760741615`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"xmax", "+", "xmin"}], "2"]], "Output",
 CellChangeTimes->{3.391164513829138*^9, 3.3911725587171183`*^9, 
  3.3911731161486654`*^9, 3.404729899558375*^9}]
}, Open  ]],

Cell[TextData[{
 "Similarly, the variance is given by Equation 2.9:\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Sigma]", "2"], "(", "x", ")"}], " ", "=", " "}], 
   TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"x", "=", "xmin"}], "xmax"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", " ", "-", " ", 
        OverscriptBox["x", "_"]}], ")"}], "2"], " ", 
     RowBox[{"P", "(", "x", ")"}]}]}], TraditionalForm]]],
 "\n\nSo we do:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119921700098753`*^9, 3.411992236485462*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "xbar"}], ")"}], "2"], " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"DiscreteUniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], ",", " ", "x"}], "]"}]}],
    ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "xmin", ",", " ", "xmax"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39116281284324*^9, 3.3911628860284753`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"xmax", "-", "xmin"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "xmax", "-", "xmin"}], ")"}]}]], "Output",
 CellChangeTimes->{3.391164536952387*^9, 3.3911725588973775`*^9, 
  3.391173116288867*^9, 3.4047298996365*^9}]
}, Open  ]],

Cell[TextData[{
 "Inevitably, the mean and variance that we have computed can be called \
directly in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": "
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411992252879035*^9, 3.4119922866676207`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Factor", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.3911640714730606`*^9, 3.391164080946683*^9}, {
  3.3911651322483807`*^9, 3.3911651344715776`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"xmax", "+", "xmin"}], "2"]], "Output",
 CellChangeTimes->{3.3911651364744577`*^9, 3.391172558937435*^9, 
  3.391173116328925*^9, 3.40472989966775*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "xmax", "-", "xmin"}], ")"}], "2"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.3911651364744577`*^9, 3.391172558937435*^9, 
  3.391173116328925*^9, 3.40472989966775*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"xmax", "-", "xmin"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "xmax", "-", "xmin"}], ")"}]}]], "Output",
 CellChangeTimes->{3.3911651364744577`*^9, 3.391172558937435*^9, 
  3.391173116328925*^9, 3.40472989966775*^9}]
}, Open  ]],

Cell["\<\
So for our fair six-sided die we have the precise values of the mean and \
variance:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.411992305674952*^9, 3.4119923274162145`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3911640714730606`*^9, 3.391164080946683*^9}, {
  3.3911651322483807`*^9, 3.3911651344715776`*^9}, {3.39116760898976*^9, 
  3.391167621988451*^9}}],

Cell[BoxData[
 FractionBox["7", "2"]], "Output",
 CellChangeTimes->{3.3911677180065184`*^9, 3.391172559027565*^9, 
  3.3911731164190545`*^9, 3.404729899699*^9}],

Cell[BoxData[
 FractionBox["35", "12"]], "Output",
 CellChangeTimes->{3.3911677180065184`*^9, 3.391172559027565*^9, 
  3.3911731164190545`*^9, 3.404729899699*^9}]
}, Open  ]],

Cell[TextData[{
 "For our pairs of six sided dice, we must define the probability \
distribution function given by Equation 2.10. We use ",
 StyleBox["Piecewise", "Input"],
 " to assign probability zero outside the interval on which our function is \
defined:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411992341476432*^9, 3.411992408903387*^9}, {
  3.411992458194264*^9, 3.4119924603473597`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "x_", "]"}], ":=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", "-", " ", 
          RowBox[{"Abs", "[", 
           RowBox[{"7", " ", "-", " ", "x"}], "]"}]}], ")"}], "/", "36"}], 
       ",", " ", 
       RowBox[{
       "2", "\[LessEqual]", " ", "x", " ", "\[LessEqual]", " ", "12"}]}], 
      "}"}], "}"}], ",", " ", "0"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3911728643966637`*^9, 3.391172987824144*^9}}],

Cell["The command Table yields the required probabilities:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119924323971696`*^9, 3.4119924548394403`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"P", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "14"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.391173038076403*^9, 3.391173077302808*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   FractionBox["1", "36"], ",", 
   FractionBox["1", "18"], ",", 
   FractionBox["1", "12"], ",", 
   FractionBox["1", "9"], ",", 
   FractionBox["5", "36"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["5", "36"], ",", 
   FractionBox["1", "9"], ",", 
   FractionBox["1", "12"], ",", 
   FractionBox["1", "18"], ",", 
   FractionBox["1", "36"], ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.3911730701825695`*^9, 3.391173116639371*^9, 
  3.4047298997615*^9}]
}, Open  ]],

Cell["\<\
and the probability distribution function sums to unity over the interval on \
which it is defined:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119924679182463`*^9, 3.4119924922031665`*^9}, 
   3.4123270226150045`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"P", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "2", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.391172386429381*^9, 3.39117240522641*^9}, {
  3.3911730808479056`*^9, 3.391173081749202*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.391172394891549*^9, 3.391172408280802*^9}, 
   3.391172559127709*^9, 3.39117308236008*^9, 3.391173116679429*^9, 
   3.40472989985525*^9}]
}, Open  ]],

Cell["\<\
We may now compute the mean, variance and standard deviation analytically. \
Displaying the standard deviation with numerical precision yields a value \
close to that we obtained by simulation of a million rolls of a pair of dice:\
\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119925055123043`*^9, 3.4119925833642497`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"xbar", " ", "=", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"P", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "2", ",", " ", "12"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"xvar", " ", "=", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "xbar"}], ")"}], "2"], " ", 
     RowBox[{"P", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "2", ",", " ", "12"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"xstd", " ", "=", " ", 
  SqrtBox["xvar"]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.391172411635626*^9, 3.391172468627576*^9}, {
  3.3911730891798863`*^9, 3.39117309612988*^9}}],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{{3.391172438954909*^9, 3.391172469428728*^9}, 
   3.391172507583592*^9, 3.3911725591677666`*^9, {3.391173096951061*^9, 
   3.391173116719486*^9}, 3.4047298998865*^9}],

Cell[BoxData[
 FractionBox["35", "6"]], "Output",
 CellChangeTimes->{{3.391172438954909*^9, 3.391172469428728*^9}, 
   3.391172507583592*^9, 3.3911725591677666`*^9, {3.391173096951061*^9, 
   3.391173116719486*^9}, 3.404729899902125*^9}],

Cell[BoxData[
 SqrtBox[
  FractionBox["35", "6"]]], "Output",
 CellChangeTimes->{{3.391172438954909*^9, 3.391172469428728*^9}, 
   3.391172507583592*^9, 3.3911725591677666`*^9, {3.391173096951061*^9, 
   3.391173116719486*^9}, 3.404729899933375*^9}],

Cell[BoxData["2.41522945769824`"], "Output",
 CellChangeTimes->{{3.391172438954909*^9, 3.391172469428728*^9}, 
   3.391172507583592*^9, 3.3911725591677666`*^9, {3.391173096951061*^9, 
   3.391173116719486*^9}, 3.404729899964625*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3. Common Probability Functions", "Section",
 Editable->False,
 CellChangeTimes->{{3.39133167090625*^9, 3.391331678640625*^9}, {
  3.4119926095719347`*^9, 3.4119926130669603`*^9}}],

Cell[CellGroupData[{

Cell["2.3.1 Bernoulli distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.391331686484375*^9, 3.391331695546875*^9}, {
  3.411992623231576*^9, 3.4119926243131313`*^9}}],

Cell[TextData[{
 "The Bernoulli distribution is used to characterise random processes where \
there are only two possible outcomes where the probability of one outcome \
('success') is p and the probability of the other outcome ('failure') is (1 - \
p). We call it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119936812028637`*^9, 3.4119937881266127`*^9}}],

Cell[BoxData[
 RowBox[{"BernoulliDistribution", "[", "p", "]"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.39133171153125*^9, 3.391331718171875*^9}}],

Cell["\<\
The probability distribution function is expressed in piecewise form:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.411993810108221*^9, 3.4119938294360127`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "n"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39133172634375*^9, 3.3913317320625*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{"1", "-", "p"}], 
     RowBox[{"n", "\[Equal]", "0"}]},
    {"p", 
     RowBox[{"n", "\[Equal]", "1"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{
  3.391331733703125*^9, 3.391332771578125*^9, {3.391333619953125*^9, 
   3.3913336450625*^9}, {3.3913347405*^9, 3.39133475896875*^9}, 
   3.391335899859375*^9, {3.391838920984375*^9, 3.391838939890625*^9}, 
   3.39184523178125*^9, 3.39184527634375*^9, 3.3918454125625*^9, 
   3.3925453607581873`*^9, 3.39255283362364*^9, 3.3926272733927712`*^9, 
   3.392978246732587*^9, 3.393155191984702*^9, 3.404729935449*^9, 
   3.404730323120875*^9, 3.4111235087814894`*^9, 3.411127106815208*^9}]
}, Open  ]],

Cell["and we obtain the mean and variance using:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119938452287216`*^9, 3.4119938539712925`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.391331766859375*^9, 3.391331787234375*^9}}],

Cell[BoxData["p"], "Output",
 CellChangeTimes->{
  3.391331790578125*^9, 3.391332771671875*^9, {3.391333620046875*^9, 
   3.391333645203125*^9}, {3.391334740625*^9, 3.391334759125*^9}, 
   3.3913359*^9, {3.3918389210625*^9, 3.39183894003125*^9}, 
   3.39184523190625*^9, 3.391845276453125*^9, 3.39184541265625*^9, 
   3.3925453610085473`*^9, 3.3925528338139133`*^9, 3.392627273512944*^9, 
   3.392978246842746*^9, 3.3931551922150335`*^9, 3.404729935527125*^9, 
   3.40473032323025*^9, 3.4111235088315616`*^9, 3.4111271069554095`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]], "Output",
 CellChangeTimes->{
  3.391331790578125*^9, 3.391332771671875*^9, {3.391333620046875*^9, 
   3.391333645203125*^9}, {3.391334740625*^9, 3.391334759125*^9}, 
   3.3913359*^9, {3.3918389210625*^9, 3.39183894003125*^9}, 
   3.39184523190625*^9, 3.391845276453125*^9, 3.39184541265625*^9, 
   3.3925453610085473`*^9, 3.3925528338139133`*^9, 3.392627273512944*^9, 
   3.392978246842746*^9, 3.3931551922150335`*^9, 3.404729935527125*^9, 
   3.40473032323025*^9, 3.4111235088315616`*^9, 3.4111271069854527`*^9}]
}, Open  ]],

Cell[TextData[{
 "The following code generates a bar chart of the Bernoulli distribution with \
probability of success p = 0.7 and probability of failure (1 - p) = 0.3. Note \
that to use the command ",
 StyleBox["BarChart", "Input"],
 ", we must first call the package ",
 StyleBox["BarCharts", "Input"],
 " using ",
 StyleBox["Needs", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411993871726824*^9, 3.411993957520189*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", " ", "=", " ", "0.7"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pn", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "n"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BarChart", "[", 
  RowBox[{"Pn", ",", " ", 
   RowBox[{"BarLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<n\>\"", ",", "\"\<P(n)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=."}]}], "Input",
 CellChangeTimes->{{3.39133179475*^9, 3.391331880125*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0.615, 0}, {1.385, 0.30000000000000004`}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{1.615, 0}, {2.385, 0.7}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"n\"", TraditionalForm], 
    FormBox["\"P(n)\"", TraditionalForm]},
  AxesOrigin->{0.3999999999999999, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{{1, 
       FormBox["1", TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}}, {{2, 
       FormBox["2", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.3999999999999999, 2.6}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["0", TraditionalForm], 0}, {2, 
      FormBox["1", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{
  3.391331883171875*^9, 3.39133277225*^9, {3.391333620734375*^9, 
   3.39133364578125*^9}, {3.391334740734375*^9, 3.391334759703125*^9}, 
   3.391335900578125*^9, {3.39183892215625*^9, 3.3918389413125*^9}, 
   3.39184523296875*^9, 3.3918452770625*^9, 3.391845413578125*^9, 
   3.3925453615192814`*^9, 3.392552834955555*^9, 3.392627274804802*^9, 
   3.392978248034459*^9, 3.393155193607035*^9, 3.404729936620875*^9, 
   3.404730323558375*^9, 3.4111235289605055`*^9, 3.411127107596331*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXMFu00AQ3WTttCfgA0CKKnGryl/AAaEWIfWCOEQVqnOoKCV38g/8A3fE
V/EVJjPruGt7lm7w2l67L0rWk/Xue7Mzs/asnfjdapN9vllt1ler5Zu71W22
vvq2fP3lblelZ0rNMqXUn6UiOd+JRZHv3vmaCqqR5Yw2c2r+gyRNUmZ2XfMm
UQYrN5VFO6Ur1dfT6lEzCkuC7Z4ZhNxG4PKy4NB7Ln5pgZChUxfOeemSGtSs
+NYYVCKPNXExXMjt5zHis/iWiuPSK5ZdaBvCLi9M3fftdpt/+viTPuqWS52/
OvtQtlsWfXd19XbUt2z30qVsCCOHVvZUjNxFOQQpVDvSQZpdXVIx00TGAqrx
UCHuQIVgABXiblRUHsm97jtra6SMC1ErKOShUEK7nw+uRnR2wQIEx2BQTYkK
cQcqBAOoEHejonpgAWLqhl6ApIJWWBHZCh0JCvGdgX4XIE41hrILboIMcejC
YRhUiDtQIRhA9eioEHcdrEH6zphGkNr6p/xEQdRfqTxpy8tecPrjd1t436VV
ayJfhx5KVA1mtpEOZC1pTv4PBCMMxA0I+AFGnCDEeP0g5h9p5cSw3z/uUx5f
9kpKKaXKX0FAa+laJ2bqOPEIC18NKSnXCOBhTN2IIGDEOCDghzggxuuHNtcj
ol2W+hOFSQt6G0cfaUFtHNLtwwAJAg8iADZmcEQQMGIcEPBDHBDj9UObP2KH
Wbr7/ZClU66Q1wx6HE2oK/DIDyYxlSOCgBHjgIAfHrURxZO760r9OM4gw91n
cBLdZw8bQjprqymXly6UQx8zIz9wh3Vx/gbe7iiFob2f5QeepOQjP3UHjGpw
X5g+T4T9kpW5PDd9juojL1vSyzyMJq3Yai8zynvz9djpy4Zn5nJ1A03/Y4r6
Yrh6Cgm9NUiruT/komIbS5aWELYDDlDUy5f3t/4OjB6fqFSzv0hR7N0=\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.2 Binomial distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3913318924375*^9, 3.391331903609375*^9}, {
  3.411993998479085*^9, 3.4119939998510575`*^9}}],

Cell[TextData[{
 "The binomial distribution extends the Bernoulli distribution to give the \
distribution of the number of 'successes' if we carry out ",
 StyleBox["m",
  FontSlant->"Italic"],
 " Bernoulli trials. It has probability function:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411994031536619*^9, 3.4119941258622527`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"m", ",", "p"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.39133193228125*^9, 3.391331968671875*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"m", "-", "x"}]], " ", 
  SuperscriptBox["p", "x"], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"m", ",", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.391331962265625*^9, 3.3913319690625*^9}, 
   3.391332655984375*^9, 3.391332737703125*^9, 3.39133277228125*^9, {
   3.39133362078125*^9, 3.3913336458125*^9}, {3.391334740765625*^9, 
   3.39133475975*^9}, 3.391335900609375*^9, 3.39183899353125*^9, 
   3.39184523303125*^9, 3.391845277109375*^9, 3.39184541365625*^9, 
   3.392545361549325*^9, 3.3925528350957565`*^9, 3.3926272750251184`*^9, 
   3.3929782481746607`*^9, 3.3931551937872944`*^9, 3.404729945089625*^9, 
   3.40473032360525*^9, 3.411123529671528*^9, 3.411127107636389*^9}]
}, Open  ]],

Cell["and the mean and variance are:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4119941292371054`*^9, 3.411994136177085*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"m", ",", "p"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"m", ",", "p"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.391332068859375*^9, 3.39133209534375*^9}}],

Cell[BoxData[
 RowBox[{"m", " ", "p"}]], "Output",
 CellChangeTimes->{{3.391332087234375*^9, 3.391332095796875*^9}, 
   3.391332656140625*^9, 3.391332737921875*^9, 3.39133277234375*^9, {
   3.391333620859375*^9, 3.39133364584375*^9}, {3.391334740796875*^9, 
   3.391334759765625*^9}, 3.391335900640625*^9, 3.39183899359375*^9, 
   3.3918452330625*^9, 3.391845277140625*^9, 3.3918454136875*^9, 
   3.3925453615993967`*^9, 3.3925528351658573`*^9, 3.392627275095219*^9, 
   3.392978248224733*^9, 3.393155193857395*^9, 3.40472994516775*^9, 
   3.4047303236365*^9, 3.411123529801715*^9, 3.411127107666432*^9}],

Cell[BoxData[
 RowBox[{"m", " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]], "Output",
 CellChangeTimes->{{3.391332087234375*^9, 3.391332095796875*^9}, 
   3.391332656140625*^9, 3.391332737921875*^9, 3.39133277234375*^9, {
   3.391333620859375*^9, 3.39133364584375*^9}, {3.391334740796875*^9, 
   3.391334759765625*^9}, 3.391335900640625*^9, 3.39183899359375*^9, 
   3.3918452330625*^9, 3.391845277140625*^9, 3.3918454136875*^9, 
   3.3925453615993967`*^9, 3.3925528351658573`*^9, 3.392627275095219*^9, 
   3.392978248224733*^9, 3.393155193857395*^9, 3.40472994516775*^9, 
   3.4047303236365*^9, 3.411123529801715*^9, 3.4111271076864605`*^9}]
}, Open  ]],

Cell[TextData[{
 "We will proceed to investigate the influence of parameters ",
 StyleBox["m",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p",
  FontSlant->"Italic"],
 " on the shape of the probability function. We define the function ",
 StyleBox["bar[m_, p_]", "Input"],
 " using the ",
 StyleBox["SetDelayed", "Input"],
 " operator '",
 StyleBox[":=", "Input"],
 "':"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119941648583264`*^9, 3.4119942653828735`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bar", "[", 
   RowBox[{"m_", ",", "p_"}], "]"}], ":=", " ", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"BinomialDistribution", "[", 
         RowBox[{"m", ",", " ", "p"}], "]"}], ",", " ", "x"}], "]"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "m"}], "}"}]}], "]"}], ",", " ", 
    
    RowBox[{"BarLabels", "\[Rule]", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "m"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39133210009375*^9, 3.391332177296875*^9}, {
  3.3913347045625*^9, 3.39133472490625*^9}}],

Cell[TextData[{
 "By inputting values to  ",
 StyleBox["bar[m_, p_]", "Input"],
 " we obtain a bar chart of the binomial probability function for those \
values of m and p:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411994276008152*^9, 3.411994302616413*^9}, {
  3.411994343104632*^9, 3.4119943666785297`*^9}, {3.411994452131405*^9, 
  3.41199447874968*^9}}],

Cell[BoxData[{
 RowBox[{"bar", "[", 
  RowBox[{"10", ",", " ", ".2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"bar", "[", 
  RowBox[{"20", ",", ".5"}], "]"}]}], "Input",
 CellChangeTimes->{{3.391337539125*^9, 3.391337553125*^9}}],

Cell[TextData[{
 "We can investigate the influence of the parameters m and p by moving the \
sliders in the ",
 StyleBox["Manipulate", "Input"],
 " object generated by the following code:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4119944989987965`*^9, 3.411994545465613*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"bar", "[", 
    RowBox[{"m", ",", "p"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", ".5"}], "}"}], ",", " ", "0", ",", " ", "1"}], "}"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"m", " ", ",", "10", ",", " ", "100", ",", "5"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.391332464609375*^9, 3.3913324978125*^9}, {
  3.391332566296875*^9, 3.39133258309375*^9}, {3.391335807234375*^9, 
  3.3913358315*^9}, {3.391335976546875*^9, 3.39133598078125*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 20, $CellContext`p$$ = 
    0.28800000000000003`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], 0.5}, 0, 1}, {
      Hold[$CellContext`m$$], 10, 100, 5}}, Typeset`size$$ = {
    95.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`p$130$$ = 
    0, $CellContext`m$135$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = 10, $CellContext`p$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`p$$, $CellContext`p$130$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$135$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`bar[$CellContext`m$$, $CellContext`p$$], 
      "Specifications" :> {{{$CellContext`p$$, 0.5}, 0, 1}, {$CellContext`m$$,
          10, 100, 5}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {61., 66.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.39133265653125*^9, 3.391332738078125*^9, 3.391332772546875*^9, {
   3.3913336211875*^9, 3.39133364603125*^9}, {3.391334740890625*^9, 
   3.3913347600625*^9}, {3.3913358774375*^9, 3.391335900890625*^9}, 
   3.391335981390625*^9, 3.39183899425*^9, 3.3918452331875*^9, 
   3.3918452774375*^9, 3.391845413796875*^9, 3.3925453617896705`*^9, 
   3.3925528385607395`*^9, 3.392627281594565*^9, 3.3929782490459137`*^9, 
   3.3931551956199293`*^9, 3.40472994541775*^9, 3.404730323714625*^9, 
   3.4111235303625216`*^9, 3.4111271077966194`*^9}]
}, Open  ]],

Cell[TextData[{
 "The skewness of the distribution describes the asymmetry of the \
distribution. If the skewness is positive, then the distribution has a long \
tail to the right and ",
 StyleBox["vice versa ",
  FontSlant->"Italic"],
 "if skewness is negative. When the skewness is zero, the distribution is \
symmetrical; for the binomial distribution, this occurs when p = ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 "."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.411994598521904*^9, 3.411994719565957*^9}, 
   3.412327039198851*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"m", ",", "p"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.391336005890625*^9, 3.39133602453125*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "p"}]}], 
  SqrtBox[
   RowBox[{"m", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]]]], "Output",
 CellChangeTimes->{3.391336025640625*^9, 3.391339108453125*^9, 
  3.391838994359375*^9, 3.391845233609375*^9, 3.391845277546875*^9, 
  3.391845414046875*^9, 3.3925453620200014`*^9, 3.3925528388912144`*^9, 
  3.3926272822655296`*^9, 3.3929782522905793`*^9, 3.3931551959003325`*^9, 
  3.404729945527125*^9, 3.404730323964625*^9, 3.411123531153659*^9, 
  3.411127108217224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.3 Poisson Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.391839083*^9, 3.391839088109375*^9}, {
  3.4119947365503793`*^9, 3.4119947383429565`*^9}}],

Cell[TextData[{
 "The Poisson distribution arises as a limiting case of the binomial \
distribution. We express the pdf of the binomial distribution in terms of the \
Euler gamma function, ",
 StyleBox["Gamma", "Input"],
 ", by applying ",
 StyleBox["FunctionExpand", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412059961809696*^9, 3.412060033532829*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"BinomialDistribution", "[", 
     RowBox[{"m", ",", "p"}], "]"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.39133193228125*^9, 3.391331968671875*^9}, {
  3.391835238265625*^9, 3.39183524140625*^9}, {3.39183539896875*^9, 
  3.391835462328125*^9}, {3.391835711015625*^9, 3.391835769234375*^9}, {
  3.391835940328125*^9, 3.39183601728125*^9}, {3.391836538921875*^9, 
  3.391836550609375*^9}, {3.391837391*^9, 3.39183742821875*^9}, {
  3.391837459203125*^9, 3.39183747534375*^9}, {3.3918376303125*^9, 
  3.39183774559375*^9}, {3.391838102359375*^9, 3.391838157078125*^9}, {
  3.391839144484375*^9, 3.391839162234375*^9}, {3.391845310515625*^9, 
  3.39184531265625*^9}, {3.391845369234375*^9, 3.391845372578125*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], 
    RowBox[{"m", "-", "x"}]], " ", 
   SuperscriptBox["p", "x"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "m"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "m", "-", "x"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]]], "Output",
 CellChangeTimes->{{3.39183914828125*^9, 3.39183916365625*^9}, {
   3.391843133890625*^9, 3.39184316128125*^9}, 3.391845233625*^9, 
   3.391845277578125*^9, 3.39184537346875*^9, 3.391845414234375*^9, 
   3.392545363181672*^9, 3.392552840002813*^9, 3.3926272833570995`*^9, 
   3.392978254033085*^9, 3.3931551963509808`*^9, 3.404729966449*^9, 
   3.40473032410525*^9, 3.4111235368418384`*^9, 3.411127108637829*^9}]
}, Open  ]],

Cell[TextData[{
 "If parameters ",
 StyleBox["m",
  FontSlant->"Italic"],
 " and ",
 StyleBox["x",
  FontSlant->"Italic"],
 " are integers, we obtain a simpler form in terms of factorials by applying \
",
 StyleBox["FullSimplify", "Input"],
 " and stating the assumption: "
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120601074090576`*^9, 3.4120601589031024`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "m"}], "}"}], "\[Element]", "Integers"}], " ", "&&", 
    " ", 
    RowBox[{"0", "\[LessEqual]", " ", "x", "<", "m"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39133193228125*^9, 3.391331968671875*^9}, {
   3.391835238265625*^9, 3.39183524140625*^9}, {3.39183539896875*^9, 
   3.391835462328125*^9}, {3.391835711015625*^9, 3.391835769234375*^9}, {
   3.391835940328125*^9, 3.39183601728125*^9}, {3.391836538921875*^9, 
   3.391836550609375*^9}, {3.391837391*^9, 3.39183742821875*^9}, {
   3.391837459203125*^9, 3.39183747534375*^9}, {3.3918376303125*^9, 
   3.39183774559375*^9}, {3.391838102359375*^9, 3.391838157078125*^9}, 
   3.391839144484375*^9, 3.39183918990625*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], 
    RowBox[{"m", "-", "x"}]], " ", 
   SuperscriptBox["p", "x"], " ", 
   RowBox[{"m", "!"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "-", "x"}], ")"}], "!"}], " ", 
   RowBox[{"x", "!"}]}]]], "Output",
 CellChangeTimes->{
  3.391839191703125*^9, {3.391843134265625*^9, 3.391843161875*^9}, 
   3.391845236078125*^9, 3.3918452779375*^9, 3.391845414484375*^9, 
   3.3925453640829678`*^9, 3.3925528404935184`*^9, 3.39262728492936*^9, 
   3.39297825461392*^9, 3.3931551966413984`*^9, 3.4047299668865*^9, 
   3.404730324339625*^9, 3.411123538263883*^9, 3.411127108918232*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability distribution function for the Poisson distribution arises \
as the limiting case of the binomial distribution when m is large and p is \
small. The binomial distribution has mean ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]]],
 "= ",
 StyleBox["m p",
  FontSlant->"Italic"],
 ", so we make the substitution ",
 StyleBox["p",
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]]],
 "/",
 StyleBox["m",
  FontSlant->"Italic"],
 " and take the limit as ",
 StyleBox["m",
  FontSlant->"Italic"],
 " tends to infinity to yield the Poisson probability function:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412060190849038*^9, 3.4120602519468927`*^9}, {
  3.412060306725661*^9, 3.4120603801412272`*^9}, {3.4120604839805408`*^9, 
  3.412060498030744*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"%", "/.", 
  RowBox[{"p", "\[Rule]", 
   RowBox[{"(", 
    RowBox[{"xbar", "/", "m"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"m", "\[Rule]", "\[Infinity]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.39133193228125*^9, 3.391331968671875*^9}, {
   3.391835238265625*^9, 3.39183524140625*^9}, {3.39183539896875*^9, 
   3.391835462328125*^9}, {3.391835711015625*^9, 3.391835769234375*^9}, {
   3.391835940328125*^9, 3.39183601728125*^9}, {3.391836538921875*^9, 
   3.391836550609375*^9}, {3.391837391*^9, 3.39183742821875*^9}, {
   3.391837459203125*^9, 3.39183747534375*^9}, {3.3918376303125*^9, 
   3.39183774559375*^9}, {3.391838102359375*^9, 3.391838157078125*^9}, 
   3.391839144484375*^9, {3.39183918990625*^9, 3.39183920684375*^9}, {
   3.3918431219375*^9, 3.3918431225*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["xbar", "m"], ")"}], "x"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["xbar", "m"]}], ")"}], 
    RowBox[{"m", "-", "x"}]], " ", 
   RowBox[{"m", "!"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "-", "x"}], ")"}], "!"}], " ", 
   RowBox[{"x", "!"}]}]]], "Output",
 CellChangeTimes->{
  3.391839208890625*^9, {3.391843127046875*^9, 3.39184316190625*^9}, 
   3.391845236109375*^9, 3.39184527796875*^9, 3.391845414515625*^9, 
   3.3925453641430545`*^9, 3.392552840553605*^9, 3.392627285009475*^9, 
   3.3929782546539774`*^9, 3.3931551967816*^9, 3.40472996691775*^9, 
   3.40473032441775*^9, 3.411123538303941*^9, 3.4111271089683037`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "xbar"}]], " ", 
   SuperscriptBox["xbar", "x"]}], 
  RowBox[{"x", "!"}]]], "Output",
 CellChangeTimes->{
  3.391839208890625*^9, {3.391843127046875*^9, 3.39184316190625*^9}, 
   3.391845236109375*^9, 3.39184527796875*^9, 3.391845414515625*^9, 
   3.3925453641430545`*^9, 3.392552840553605*^9, 3.392627285009475*^9, 
   3.3929782546539774`*^9, 3.3931551967816*^9, 3.40472996691775*^9, 
   3.40473032441775*^9, 3.411123538303941*^9, 3.41112711062068*^9}]
}, Open  ]],

Cell[TextData[{
 "Of course, we can call this function directly in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " :"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412060502557253*^9, 3.412060528274232*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "xbar", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.39183816215625*^9, 3.391838175875*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "xbar"}]], " ", 
   SuperscriptBox["xbar", "x"]}], 
  RowBox[{"x", "!"}]]], "Output",
 CellChangeTimes->{3.391838176390625*^9, 3.3918452385*^9, 
  3.391845279265625*^9, 3.391845416828125*^9, 3.3925453656352*^9, 
  3.3925528425064125`*^9, 3.3926272876332483`*^9, 3.392978256496627*^9, 
  3.3931551987544365`*^9, 3.404729968527125*^9, 3.4047303257615*^9, 
  3.4111235410178432`*^9, 3.4111271108810544`*^9}]
}, Open  ]],

Cell["\<\
Note that the variance of the Poisson distribution is equal to the mean:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412060534923794*^9, 3.4120605466506557`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"PoissonDistribution", "[", "xbar", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"PoissonDistribution", "[", "xbar", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.39183816215625*^9, 3.391838175875*^9}, {
  3.39184321428125*^9, 3.39184323090625*^9}}],

Cell[BoxData["xbar"], "Output",
 CellChangeTimes->{3.39184523853125*^9, 3.391845279296875*^9, 
  3.391845416859375*^9, 3.392545365685272*^9, 3.392552842566499*^9, 
  3.392627287663291*^9, 3.3929782565266705`*^9, 3.3931551987944946`*^9, 
  3.40472996854275*^9, 3.40473032579275*^9, 3.4111235410378723`*^9, 
  3.4111271109811983`*^9}],

Cell[BoxData["xbar"], "Output",
 CellChangeTimes->{3.39184523853125*^9, 3.391845279296875*^9, 
  3.391845416859375*^9, 3.392545365685272*^9, 3.392552842566499*^9, 
  3.392627287663291*^9, 3.3929782565266705`*^9, 3.3931551987944946`*^9, 
  3.40472996854275*^9, 3.40473032579275*^9, 3.4111235410378723`*^9, 
  3.411127110991213*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4 Probability Density Functions", "Section",
 Editable->False,
 CellChangeTimes->{{3.391854936859375*^9, 3.39185495575*^9}, {
  3.412060563675136*^9, 3.4120605643260717`*^9}}],

Cell[CellGroupData[{

Cell["2.4.1 Uniform Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3918549599375*^9, 3.391854966578125*^9}, {
  3.41206057212729*^9, 3.41206057344919*^9}}],

Cell["\<\
The uniform distribution is the continuous analogue of the discrete uniform \
distribution, which we encountered earlier. It has probability density \
function:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412060590363512*^9, 3.412060640205181*^9}, 
   3.412327046198917*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",\

 CellChangeTimes->{{3.391853599078125*^9, 3.391853638046875*^9}, {
  3.39185476128125*^9, 3.39185476446875*^9}}],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox["1", 
      RowBox[{"xmax", "-", "xmin"}]], 
     RowBox[{"xmin", "\[LessEqual]", "x", "\[LessEqual]", "xmax"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{3.391853620203125*^9, 3.391854765828125*^9, 
  3.39185667365625*^9, 3.3925453658955746`*^9, 3.3925528427667875`*^9, 
  3.392627287753421*^9, 3.3929782565967712`*^9, 3.393155198884624*^9, 
  3.404729985370875*^9, 3.404730331370875*^9, 3.4111235529449935`*^9}]
}, Open  ]],

Cell["\<\
The mean and variance are determined by the size of the interval on which the \
distribution is defined:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412060650870517*^9, 3.4120606751554365`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"xmin", ",", "xmax"}], "}"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.391854724734375*^9, 3.3918547385625*^9}, {
  3.391854777515625*^9, 3.391854793140625*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"xmax", "+", "xmin"}], "2"]], "Output",
 CellChangeTimes->{{3.391854780890625*^9, 3.391854793515625*^9}, 
   3.391856673796875*^9, 3.3925453659456463`*^9, 3.3925528428168592`*^9, 
   3.3926272878034925`*^9, 3.3929782566268144`*^9, 3.393155198914667*^9, 
   3.404729985449*^9, 3.404730331449*^9, 3.4111235530451374`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"xmax", "-", "xmin"}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{{3.391854780890625*^9, 3.391854793515625*^9}, 
   3.391856673796875*^9, 3.3925453659456463`*^9, 3.3925528428168592`*^9, 
   3.3926272878034925`*^9, 3.3929782566268144`*^9, 3.393155198914667*^9, 
   3.404729985449*^9, 3.404730331449*^9, 3.4111235530851955`*^9}]
}, Open  ]],

Cell[TextData[{
 "Note that whereas probabilities must take values between 0 and 1, \
probability ",
 StyleBox["densities",
  FontSlant->"Italic"],
 " can be greater than 1:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120606852599664`*^9, 3.4120607194791713`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"UniformDistribution", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "x"}], "]"}], ",", " ",
        
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}], ",", " ", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"UniformDistribution", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1.5"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.391853641109375*^9, 3.391853670921875*^9}, {
  3.391853912234375*^9, 3.39185391828125*^9}, {3.39185399759375*^9, 
  3.391854012125*^9}, {3.391854429140625*^9, 3.391854432671875*^9}, {
  3.391854469109375*^9, 3.3918546524375*^9}, {3.391854684234375*^9, 
  3.391854708609375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN0XlM03cYBvAWKLAuDGSFiIJjHD86dIPFepQMCgOsoBw6pJRiuWyFgkAI
96UrlJmsRWnHJiPAylAgOh2nmzhMTTgcUiUUCBv3BOQQarmRwrZEv+/vSd48
+fz3Js/HUYlneToEAkH43/3fG6cSygMTk9wIb1N4wYH6DPNnvHPP4guBBOMi
qxs9xfFYArLQfNkyDMtD7u70nfoKK0JO/CntSQBWgawQi1v9sLvIJP1kg1nB
I2Sfy5Gi5uBO5PuZvJGbvUrkodA4p+T0PuQ9TAlf4T6IbKLiNRzj/I1sax1f
J4oaQz4+cqnbQzoB/2xdOa0q+wc55lFXV5twCrk0umafWcQM8qchE2s7vFnk
0eUApbvPPLJmzMLZ/NwrZOvoddpH58EB0yo6lQe+s3DN0yUVzN8ksbgl4L9M
Nbm3+sEK7z+7jwYvwh5dNc8ZXPCB06L+k3xw1ln3sdA0MC28RZP3Pbg2o8qi
cwB8/XbWRRZrCZlD9H7azwVjLOPPg/jghzrVW4Gp4JfsHomvDNx47wdN14/g
PFIUi1kFptSvWXvVgxmG1k2uz8Bk7tzehwNgVWNTrssouPK9y5O/TYEF4T7M
Y6/AR5o/vNO8Aia8P2pC2wbznVUuQ0T1W6sZpzj0SzdI4Al95dESCji9IYog
tQUrI5oxUTgYMzb0yygDLzK8cvKtXiO3JF25XVQJVtnLDM5INch2+X3U86XL
yPTAMVpl2QrySJLITSJeRW6gs43ai9eQzYM7h2pF68iMSULx45QN5FLzGCMs
YxNZWBH7zRHBFnK58kZHUdIb5NwEmdoqeRt5PpK6lx2lRf5WO6c3yt9Btkm1
yEobBz9YYC59ELqLnKYnra4tAR+2HGZ/2Qu2qfqskzoONqV+TTNeApPjHOOE
a2Di3T75qhbc5vBdxSCB4P5u35wMt/gmHbDLk5f0Yj3whoXMIEEf3CJw7fc1
BKe0zlQ5kMHqsC/cJozAM5VTKUFm4AH745MuduAXvfGe7hhYkyuv9qaCjQfI
FwMPgU8WjszzaOAH08LV617gypoew5kL4JhPop1kN8GKYE62xwEi8uGQuTqK
HByff2LQdb8O8lW+4RZRBv7DKnJ3jqKL/PtOoa5jEVjZ6Dkn2aOH3G7N7xBL
wQX3z8knyCTkMJthLkcCftPitP+ggT5yju7s05I8sLkdPdKeYICcnhC8Qs4E
vxaTBWbbYMsCD4o9zszsjDYazuWx06ZBOPuceNwqxVm+m2lkogWfSZ79lbwD
zom15uzDuSaCRXLEWevfzvbBue6gXOcqzsSpkCDSLvjQ8LUdCs6svo5aO5x/
UdC0njizK0xuCXEuKGEGSnG+J87bkuNMyl7wV+DsnGy7+RxnTmzoz+M4F0YU
+6lxrmd1re/i/C+n/QW9
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 3}, {0., 1.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, ImageScaled[{0.5, 0.5}],
      {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxN1HlM03cUAPAfR4HVMVAr414n8JPhFtgsCmRKCWqHyKFCC62Wy3bQIZAG
BeRyQNFsLUpJnYwA4iZHZCJHwYNhagJ0opWFAmETEAQmWBAL46gUtiXj+34v
efnm89d73/eS93Fs8nGeIYZhon/zv3clMKk8NDnlAPZ/FJ7e5foMD/bd9NO5
CYEE5yLPN/uLE/Ek5DyrBfuTeA5yT/eRyRN4EXLy9XO/heAVyAqx+EEQfhuZ
ZCI0nRY8RA7IjRHJmd3IbRm84Zu/q5CH2N+4C9P6kLcyJHwFfRDZUs1r2sf5
E9mJmlgnih1F9ho+0+MnHYN+dBeOqsteIsc/VCo78iaRS+NqbHdE/4X8WcTY
0jpvGnlkIURFD3iNrB218bAKn0Wmxi3TPjoFDplSe7vywPWay/4+Z8H8VRKL
KwP/sU2bXd0PVhx63LOXOQf7UNb0+nLBjkdF/V/xweeP00fZ58C0qFZtzlVw
bfoNm+4B8JVb579msd4gcwwOPenngnGWxedhfHC74c+60LPgV5FPJUdKwM0N
P2iVP4JzSLEsxg0wpXGJerAR7GtGbdn/DEzmzli3D4DVzS3ZPiPgyvdyx+9O
ggVRAYx9s2BP+fZ6+SIY2zJiSVsD8z3UPkMG85umB3K8z1wjgcdMVHtlFHBa
UywmdQKrouW4KAqMW5gFpZeB53wPZuU7vEVuTblwq6gSrHYpMT0m1SI75/e5
nipdQPYOHaVVli0iD6eIDkjEfyM3eUeadxYvIU8wriy0bllGtmJ2D9WKwNR7
MkayAuxmf1ruqQezDf3stdgKms/3rxzybxuD21W6aYEZWNMyGLrrfbBDWUvb
Swtw8LfFjte3gxuCAjXWduAXe1xP9DuCLW1J94t3goVTHRfJbmBa7hdOa15g
Hs/iu7tfgq8GauZT6eDlD6s7Zhng+3ds2KNMsO84VvwolVA/V+vYmw4et5uo
H84CF4R3K1cKwI+VEsxdBmY22KaUycGJWbSQ1CVwqVW8OZ6+CvezIuGip0CH
XK661lWU8g45O6lk3kG4hvw6xtU6MlYP+9HPGI/w1+F/GsabD9gbyAMuXuM+
zhh90/GfxLmX3AQrmJxMP0cD5D0RM3WUKnBi/uHB/XaGyJf4ZjqDEvCvDjEb
MxQj5HvrhUZuRWBVs/+MZKsxcieV3yWWggvawqvGyCTkkzufczkS8LtWd7vd
pibIWUbTT2Q5YCtn7xgXzBQ5LYm5SM4AvxWTBTvWwPYFfhQXghmZ6R00gssT
praFERxw+NEDKcFVGxnmlnrwMeH0HfI6OCuByrEluCaaRXIjWB/cGRlAcN3u
KsNLBBtMRoSRNsCfPr+8TiGY1ddV60zwLwqa3p/gyArL6jyCC2SMUCnBDeIc
XRXBpExNsIJgD6HTai/BnAT2Ty8ILowuDponuJGlXN4g+B8jFwJk
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 3}, {0., 2.}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.391853673625*^9, 3.391853919453125*^9, {3.391853999328125*^9, 
   3.391854012671875*^9}, 3.391854433375*^9, {3.3918544786875*^9, 
   3.391854508109375*^9}, {3.391854553171875*^9, 3.39185465384375*^9}, {
   3.391854689828125*^9, 3.3918547089375*^9}, 3.391856673921875*^9, 
   3.3925453661158915`*^9, 3.392552843367651*^9, 3.3926272884744577`*^9, 
   3.392978257217664*^9, 3.393155199735848*^9, 3.40472998566775*^9, 
   3.40473033154275*^9, 3.4111235535959296`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.2 Normal (Gaussian) Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.39185875815625*^9, 3.391858768234375*^9}, {
  3.4120607362633057`*^9, 3.4120607384965167`*^9}}],

Cell["\<\
The probability density of the normal, or Gaussian, distribution is defined \
in terms of its mean and variance:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120607750991488`*^9, 3.4120608018075533`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], ",", " ", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.39185846671875*^9, 3.391858477109375*^9}, {
  3.391858781265625*^9, 3.391858781578125*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]], "Output",
 CellChangeTimes->{3.3918588124375*^9, 3.3925453661759777`*^9, 
  3.39255284347781*^9, 3.392627288784904*^9, 3.392978257317808*^9, 
  3.393155199916107*^9, 3.40472999404275*^9, 3.40473033441775*^9, 
  3.4111235601753902`*^9, 3.41206147458496*^9}],

Cell[BoxData["\[Mu]"], "Output",
 CellChangeTimes->{3.3918588124375*^9, 3.3925453661759777`*^9, 
  3.39255284347781*^9, 3.392627288784904*^9, 3.392978257317808*^9, 
  3.393155199916107*^9, 3.40472999404275*^9, 3.40473033441775*^9, 
  3.4111235601753902`*^9, 3.4120614746250176`*^9}],

Cell[BoxData[
 SuperscriptBox["\[Sigma]", "2"]], "Output",
 CellChangeTimes->{3.3918588124375*^9, 3.3925453661759777`*^9, 
  3.39255284347781*^9, 3.392627288784904*^9, 3.392978257317808*^9, 
  3.393155199916107*^9, 3.40472999404275*^9, 3.40473033441775*^9, 
  3.4111235601753902`*^9, 3.4120614747051325`*^9}]
}, Open  ]],

Cell["\<\
The distribution is symmetrical and defined on the interval [-\[Infinity], \
\[Infinity]]:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412060809438526*^9, 3.4120608289165344`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", " ", "x"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", " ", "\"\<Probability density, f(x)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39185853571875*^9, 3.391858569703125*^9}, {
  3.391859177921875*^9, 3.39185921521875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12nk0FW/8B3Cu/d7rXktKZY+yFlnK+hmSlCVk31OWKKksSdlClixfWwjZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"Probability density, f(x)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{-4, 4}, {0., 0.39894220478008047`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.3918585629375*^9, 3.391858570046875*^9}, {
   3.39185921609375*^9, 3.391859228421875*^9}, 3.392545366406309*^9, 
   3.3925528438082848`*^9, 3.3926272893957825`*^9, 3.392978257648283*^9, 
   3.3931552005269856`*^9, 3.40472999435525*^9, 3.404730334699*^9, 
   3.4111235606660957`*^9, 3.4120614768382*^9}]
}, Open  ]],

Cell[TextData[{
 "The normal distribution arises as a consequence of the Central Limit \
Theorem which, informally, states that the mean of independent and identical \
distributions with mean \[Mu] and variance ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]]],
 "is approximately normal with mean \[Mu] and variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "/", "n"}], TraditionalForm]]],
 ". We demonstrate it by computing the mean of 2, 3 and 10 uniformly \
distributed random variables with mean zero."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120608995681267`*^9, 3.412060901981597*^9}, {
   3.412061061621147*^9, 3.412061151720704*^9}, {3.412061213289235*^9, 
   3.412061322696555*^9}, 3.4123270536896877`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", " ", 
   RowBox[{"StandardDeviation", "[", 
    RowBox[{"UniformDistribution", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<Histograms`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"H", "[", "n_", "]"}], ":=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Histogram", "[", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"n", ",", "50000"}], "}"}]}], "]"}], "]"}], ",", " ", 
      RowBox[{"HistogramCategories", "\[Rule]", "50"}], ",", " ", 
      RowBox[{"HistogramScale", "\[Rule]", "1"}]}], "]"}], ",", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", " ", 
          RowBox[{"\[Sigma]", "/", 
           SqrtBox["n"]}]}], "]"}], ",", " ", "x"}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", ".015", "]"}]}]}], "]"}]}], "]"}]}], "\n", 
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H", "[", "1", "]"}], ",", " ", 
      RowBox[{"H", "[", "2", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H", "[", "3", "]"}], ",", 
      RowBox[{"H", "[", "10", "]"}]}], "}"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]", " ", "=", " ", "."}]}], "Input",
 CellChangeTimes->{{3.391859325828125*^9, 3.3918593369375*^9}, {
   3.391859375328125*^9, 3.391859390875*^9}, {3.3918596094375*^9, 
   3.391859670421875*^9}, {3.391859717921875*^9, 3.391859885078125*^9}, {
   3.391859974796875*^9, 3.39186007503125*^9}, {3.39186016471875*^9, 
   3.39186017375*^9}, 3.392534245365037*^9, {3.392534589169403*^9, 
   3.3925346602516146`*^9}, 3.3925346986868815`*^9, {3.392534809756592*^9, 
   3.3925348381674447`*^9}, {3.392534879607032*^9, 3.3925349448408337`*^9}, {
   3.39253500598876*^9, 3.392535010895816*^9}, {3.392535583719496*^9, 
   3.392535595115883*^9}, {3.3925450487395267`*^9, 3.3925450531258335`*^9}, 
   3.3925451831528034`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-1., 0}, {-0.95, 0.4899999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.95, 0}, \
{-0.8999999999999999, 0.48839999999999956`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8999999999999999, 0}, \
{-0.8499999999999999, 0.5035999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8499999999999999, 0}, \
{-0.7999999999999998, 0.5111999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7999999999999998, 0}, \
{-0.7499999999999998, 0.5043999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7499999999999998, 0}, \
{-0.6999999999999997, 0.5107999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6999999999999997, 0}, \
{-0.6499999999999997, 0.5407999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6499999999999997, 0}, \
{-0.5999999999999996, 0.4967999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5999999999999996, 0}, \
{-0.5499999999999996, 0.5095999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5499999999999996, 0}, \
{-0.49999999999999956`, 0.48879999999999957`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.49999999999999956`, 0}, \
{-0.4499999999999995, 0.4987999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.4499999999999995, 0}, \
{-0.39999999999999947`, 0.48879999999999957`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.39999999999999947`, 0}, \
{-0.3499999999999994, 0.5159999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.3499999999999994, 0}, \
{-0.2999999999999994, 0.4963999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.2999999999999994, 0}, \
{-0.24999999999999933`, 0.4879999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.24999999999999933`, 0}, \
{-0.1999999999999993, 0.5047999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.1999999999999993, 0}, \
{-0.14999999999999925`, 0.48439999999999955`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.14999999999999925`, 0}, \
{-0.0999999999999992, 0.5127999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.0999999999999992, 0}, \
{-0.049999999999999156`, 0.5031999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          
          RectangleBox[{-0.049999999999999156`, 0}, \
{8.881784197001252*^-16, 0.4819999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{8.881784197001252*^-16, 0}, \
{0.05000000000000093, 0.4819999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.05000000000000093, 0}, \
{0.10000000000000098`, 0.4871999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.10000000000000098`, 0}, \
{0.15000000000000102`, 0.5239999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.15000000000000102`, 0}, \
{0.20000000000000107`, 0.5147999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.20000000000000107`, 0}, \
{0.2500000000000011, 0.49239999999999956`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.2500000000000011, 0}, \
{0.30000000000000115`, 0.5043999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.30000000000000115`, 0}, \
{0.3500000000000012, 0.49439999999999956`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.3500000000000012, 0}, \
{0.40000000000000124`, 0.5011999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.40000000000000124`, 0}, \
{0.4500000000000013, 0.5099999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.4500000000000013, 0}, \
{0.5000000000000013, 0.4467999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5000000000000013, 0}, \
{0.5500000000000014, 0.48439999999999955`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5500000000000014, 0}, \
{0.6000000000000014, 0.4967999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6000000000000014, 0}, \
{0.6500000000000015, 0.5047999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6500000000000015, 0}, \
{0.7000000000000015, 0.5047999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7000000000000015, 0}, \
{0.7500000000000016, 0.5343999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7500000000000016, 0}, \
{0.8000000000000016, 0.5095999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8000000000000016, 0}, \
{0.8500000000000016, 0.4851999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8500000000000016, 0}, \
{0.9000000000000017, 0.5111999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9000000000000017, 0}, \
{0.9500000000000017, 0.48399999999999954`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9500000000000017, 0}, \
{1.0000000000000018`, 0.5079999999999996}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], Thickness[0.015], LineBox[CompressedData["
1:eJw113k0VO//AHCyFSoqJEuSFCFSSqV3JLSIqZSStVAkkkJkJ0tKUtYsUZaE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           "]]}}},
       AlignmentPoint->Center,
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->None,
       AxesOrigin->{-1., 0},
       AxesStyle->{},
       Background->None,
       BaseStyle->{},
       BaselinePosition->Automatic,
       ColorOutput->Automatic,
       ContentSelectable->Automatic,
       DisplayFunction:>$DisplayFunction,
       Epilog->{},
       FormatType:>TraditionalForm,
       Frame->False,
       FrameLabel->None,
       FrameStyle->{},
       FrameTicks->Automatic,
       FrameTicksStyle->{},
       GridLines->None,
       GridLinesStyle->{},
       ImageMargins->0.,
       ImagePadding->All,
       ImageSize->Automatic,
       LabelStyle->{},
       Method->Automatic,
       PlotLabel->None,
       PlotRange->{{-1., 1.0000000000000018`}, All},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       PlotRegion->Automatic,
       PreserveImageOptions->Automatic,
       Prolog->{},
       RotateLabel->True,
       Ticks->{{{-1., 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
           FormBox[
            RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {0.5, 
           FormBox["0.5`", TraditionalForm]}, {1., 
           FormBox["1", TraditionalForm]}}, Automatic},
       TicksStyle->{}], {192., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-1., 0}, {-0.95, 0.026799999999999977`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.95, 0}, \
{-0.8999999999999999, 0.07919999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8999999999999999, 0}, \
{-0.8499999999999999, 0.12119999999999989`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8499999999999999, 0}, \
{-0.7999999999999998, 0.18159999999999982`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7999999999999998, 0}, \
{-0.7499999999999998, 0.2255999999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7499999999999998, 0}, \
{-0.6999999999999997, 0.2695999999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6999999999999997, 0}, \
{-0.6499999999999997, 0.3455999999999997}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6499999999999997, 0}, \
{-0.5999999999999996, 0.37959999999999966`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5999999999999996, 0}, \
{-0.5499999999999996, 0.40999999999999964`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5499999999999996, 0}, \
{-0.49999999999999956`, 0.4691999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.49999999999999956`, 0}, \
{-0.4499999999999995, 0.5051999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.4499999999999995, 0}, \
{-0.39999999999999947`, 0.5899999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.39999999999999947`, 0}, \
{-0.3499999999999994, 0.6399999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.3499999999999994, 0}, \
{-0.2999999999999994, 0.6691999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.2999999999999994, 0}, \
{-0.24999999999999933`, 0.7195999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.24999999999999933`, 0}, \
{-0.1999999999999993, 0.7679999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.1999999999999993, 0}, \
{-0.14999999999999925`, 0.8443999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.14999999999999925`, 0}, \
{-0.0999999999999992, 0.8499999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.0999999999999992, 0}, \
{-0.049999999999999156`, 0.9219999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.049999999999999156`, 0}, \
{8.881784197001252*^-16, 0.9771999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{8.881784197001252*^-16, 0}, \
{0.05000000000000093, 0.9831999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.05000000000000093, 0}, \
{0.10000000000000098`, 0.8935999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.10000000000000098`, 0}, \
{0.15000000000000102`, 0.8995999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.15000000000000102`, 0}, \
{0.20000000000000107`, 0.8011999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.20000000000000107`, 0}, \
{0.2500000000000011, 0.7799999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.2500000000000011, 0}, \
{0.30000000000000115`, 0.7471999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.30000000000000115`, 0}, \
{0.3500000000000012, 0.6583999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.3500000000000012, 0}, \
{0.40000000000000124`, 0.6251999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.40000000000000124`, 0}, \
{0.4500000000000013, 0.5959999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.4500000000000013, 0}, \
{0.5000000000000013, 0.5291999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5000000000000013, 0}, \
{0.5500000000000014, 0.46719999999999956`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5500000000000014, 0}, \
{0.6000000000000014, 0.4419999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6000000000000014, 0}, \
{0.6500000000000015, 0.3627999999999997}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6500000000000015, 0}, \
{0.7000000000000015, 0.31079999999999974`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7000000000000015, 0}, \
{0.7500000000000016, 0.27799999999999975`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7500000000000016, 0}, \
{0.8000000000000016, 0.2255999999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8000000000000016, 0}, \
{0.8500000000000016, 0.17919999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8500000000000016, 0}, \
{0.9000000000000017, 0.1307999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9000000000000017, 0}, \
{0.9500000000000017, 0.07839999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9500000000000017, 0}, \
{1.0000000000000018`, 0.017599999999999984`}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], Thickness[0.015], LineBox[CompressedData["
1:eJw12HkwVW/cAHBCIlmKSpZsKdtNyFL0RZL8frIUUSL9QlFCEokkFcqSXZYU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           "]]}}},
       AlignmentPoint->Center,
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->None,
       AxesOrigin->{-1., 0},
       AxesStyle->{},
       Background->None,
       BaseStyle->{},
       BaselinePosition->Automatic,
       ColorOutput->Automatic,
       ContentSelectable->Automatic,
       DisplayFunction:>$DisplayFunction,
       Epilog->{},
       FormatType:>TraditionalForm,
       Frame->False,
       FrameLabel->None,
       FrameStyle->{},
       FrameTicks->Automatic,
       FrameTicksStyle->{},
       GridLines->None,
       GridLinesStyle->{},
       ImageMargins->0.,
       ImagePadding->All,
       ImageSize->Automatic,
       LabelStyle->{},
       Method->Automatic,
       PlotLabel->None,
       PlotRange->{{-1., 1.0000000000000018`}, All},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       PlotRegion->Automatic,
       PreserveImageOptions->Automatic,
       Prolog->{},
       RotateLabel->True,
       Ticks->{{{-1., 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
           FormBox[
            RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {0.5, 
           FormBox["0.5`", TraditionalForm]}, {1., 
           FormBox["1", TraditionalForm]}}, Automatic},
       TicksStyle->{}], {576., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {InsetBox[
      GraphicsBox[{{
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-1., 0}, {-0.95, 0.0019999999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.95, 0}, \
{-0.8999999999999999, 0.01159999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8999999999999999, 0}, \
{-0.8499999999999999, 0.03079999999999997}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.8499999999999999, 0}, \
{-0.7999999999999998, 0.05639999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7999999999999998, 0}, \
{-0.7499999999999998, 0.07519999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7499999999999998, 0}, \
{-0.6999999999999997, 0.12279999999999988`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6999999999999997, 0}, \
{-0.6499999999999997, 0.18479999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6499999999999997, 0}, \
{-0.5999999999999996, 0.23839999999999978`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5999999999999996, 0}, \
{-0.5499999999999996, 0.30679999999999974`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5499999999999996, 0}, \
{-0.49999999999999956`, 0.3703999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.49999999999999956`, 0}, \
{-0.4499999999999995, 0.48839999999999956`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          
          RectangleBox[{-0.4499999999999995, 0}, \
{-0.39999999999999947`, 0.5951999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.39999999999999947`, 0}, \
{-0.3499999999999994, 0.6579999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.3499999999999994, 0}, \
{-0.2999999999999994, 0.7783999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.2999999999999994, 0}, \
{-0.24999999999999933`, 0.8499999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.24999999999999933`, 0}, \
{-0.1999999999999993, 0.9519999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.1999999999999993, 0}, \
{-0.14999999999999925`, 0.9947999999999991}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.14999999999999925`, 0}, \
{-0.0999999999999992, 1.059599999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.0999999999999992, 0}, \
{-0.049999999999999156`, 1.141599999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.049999999999999156`, 0}, \
{8.881784197001252*^-16, 1.117199999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{8.881784197001252*^-16, 0}, \
{0.05000000000000093, 1.125999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.05000000000000093, 0}, \
{0.10000000000000098`, 1.091599999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.10000000000000098`, 0}, \
{0.15000000000000102`, 1.0439999999999992`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.15000000000000102`, 0}, \
{0.20000000000000107`, 1.023199999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.20000000000000107`, 0}, \
{0.2500000000000011, 0.9503999999999991}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.2500000000000011, 0}, \
{0.30000000000000115`, 0.8659999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.30000000000000115`, 0}, \
{0.3500000000000012, 0.7739999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.3500000000000012, 0}, \
{0.40000000000000124`, 0.6439999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.40000000000000124`, 0}, \
{0.4500000000000013, 0.5635999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.4500000000000013, 0}, \
{0.5000000000000013, 0.46239999999999964`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5000000000000013, 0}, \
{0.5500000000000014, 0.37959999999999966`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5500000000000014, 0}, \
{0.6000000000000014, 0.31839999999999974`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6000000000000014, 0}, \
{0.6500000000000015, 0.2483999999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6500000000000015, 0}, \
{0.7000000000000015, 0.17519999999999986`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7000000000000015, 0}, \
{0.7500000000000016, 0.12279999999999988`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7500000000000016, 0}, \
{0.8000000000000016, 0.09279999999999992}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8000000000000016, 0}, \
{0.8500000000000016, 0.04399999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.8500000000000016, 0}, \
{0.9000000000000017, 0.027999999999999976`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9000000000000017, 0}, \
{0.9500000000000017, 0.007999999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.9500000000000017, 0}, \
{1.0000000000000018`, 0.0031999999999999976`}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], Thickness[0.015], LineBox[CompressedData["
1:eJw12Xk0VG/cAHBEIkmJIiRb9i1r/fgWJSmKImQvCpEkoixJwsi+7yHZsk7Z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           "]]}}},
       AlignmentPoint->Center,
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->None,
       AxesOrigin->{-1., 0},
       AxesStyle->{},
       Background->None,
       BaseStyle->{},
       BaselinePosition->Automatic,
       ColorOutput->Automatic,
       ContentSelectable->Automatic,
       DisplayFunction:>$DisplayFunction,
       Epilog->{},
       FormatType:>TraditionalForm,
       Frame->False,
       FrameLabel->None,
       FrameStyle->{},
       FrameTicks->Automatic,
       FrameTicksStyle->{},
       GridLines->None,
       GridLinesStyle->{},
       ImageMargins->0.,
       ImagePadding->All,
       ImageSize->Automatic,
       LabelStyle->{},
       Method->Automatic,
       PlotLabel->None,
       PlotRange->{{-1., 1.0000000000000018`}, All},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       PlotRegion->Automatic,
       PreserveImageOptions->Automatic,
       Prolog->{},
       RotateLabel->True,
       Ticks->{{{-1., 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
           FormBox[
            RowBox[{"-", "0.5`"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {0.5, 
           FormBox["0.5`", TraditionalForm]}, {1., 
           FormBox["1", TraditionalForm]}}, Automatic},
       TicksStyle->{}], {192., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7250000000000001, 0}, \
{-0.7000000000000002, 0.0007999999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.7, 0}, {-0.675, 0.0007999999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.675, 0}, \
{-0.6500000000000001, 0.0015999999999999988`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.6499999999999999, 0}, \
{-0.625, 0.0007999999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.625, 0}, \
{-0.6000000000000001, 0.005599999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5999999999999999, 0}, \
{-0.575, 0.01119999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.575, 0}, {-0.55, 0.011999999999999988`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5499999999999998, 0}, \
{-0.5249999999999999, 0.027199999999999978`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.5249999999999999, 0}, \
{-0.49999999999999994`, 0.03679999999999997}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.4999999999999999, 0}, \
{-0.47499999999999987`, 0.04799999999999995}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.47499999999999987`, 0}, \
{-0.44999999999999984`, 0.08239999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.44999999999999984`, 0}, \
{-0.4249999999999998, 0.1199999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.4249999999999998, 0}, \
{-0.3999999999999998, 0.18719999999999984`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.3999999999999998, 0}, \
{-0.3749999999999998, 0.24799999999999978`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.3749999999999998, 0}, \
{-0.34999999999999976`, 0.29599999999999976`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.34999999999999976`, 0}, \
{-0.32499999999999973`, 0.43279999999999963`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.32499999999999973`, 0}, \
{-0.2999999999999997, 0.5191999999999996}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.2999999999999997, 0}, \
{-0.2749999999999997, 0.6743999999999994}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.2749999999999997, 0}, \
{-0.24999999999999967`, 0.8119999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.24999999999999967`, 0}, \
{-0.22499999999999964`, 0.9343999999999991}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.22499999999999964`, 0}, \
{-0.19999999999999962`, 1.127999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.19999999999999962`, 0}, \
{-0.1749999999999996, 1.2631999999999988`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.1749999999999996, 0}, \
{-0.14999999999999958`, 1.5183999999999986`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.14999999999999958`, 0}, \
{-0.12499999999999956`, 1.6031999999999984`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.12499999999999956`, 0}, \
{-0.09999999999999953, 1.8343999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.09999999999999953, 0}, \
{-0.07499999999999951, 1.9135999999999984`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.07499999999999951, 0}, \
{-0.04999999999999949, 2.0111999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{-0.04999999999999949, 0}, \
{-0.024999999999999467`, 2.069599999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          
          RectangleBox[{-0.024999999999999467`, 0}, \
{5.551115123125783*^-16, 2.1039999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{5.551115123125783*^-16, 0}, \
{0.025000000000000577`, 2.162399999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.025000000000000577`, 0}, \
{0.0500000000000006, 2.0423999999999984`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.0500000000000006, 0}, \
{0.07500000000000062, 2.040799999999998}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.07500000000000062, 0}, \
{0.10000000000000064`, 1.9455999999999984`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.10000000000000064`, 0}, \
{0.12500000000000067`, 1.8215999999999983`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.12500000000000067`, 0}, \
{0.1500000000000007, 1.6415999999999986`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.1500000000000007, 0}, \
{0.1750000000000007, 1.4919999999999987`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.1750000000000007, 0}, \
{0.20000000000000073`, 1.291999999999999}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.20000000000000073`, 0}, \
{0.22500000000000075`, 1.1855999999999989`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.22500000000000075`, 0}, \
{0.2500000000000008, 0.9719999999999991}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.2500000000000008, 0}, \
{0.2750000000000008, 0.7743999999999993}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.2750000000000008, 0}, \
{0.3000000000000007, 0.6440000000000022}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.3000000000000007, 0}, \
{0.32500000000000084`, 0.5215999999999972}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.32500000000000084`, 0}, \
{0.350000000000001, 0.4039999999999978}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.350000000000001, 0}, \
{0.3750000000000009, 0.3192000000000011}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.3750000000000009, 0}, \
{0.4000000000000008, 0.28240000000000104`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.4000000000000008, 0}, \
{0.42500000000000093`, 0.17439999999999908`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.42500000000000093`, 0}, \
{0.45000000000000107`, 0.12559999999999932`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.45000000000000107`, 0}, \
{0.475000000000001, 0.10000000000000035`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.475000000000001, 0}, \
{0.5000000000000009, 0.06000000000000021}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5000000000000009, 0}, \
{0.525000000000001, 0.036799999999999805`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.525000000000001, 0}, \
{0.5500000000000012, 0.025599999999999866`}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5500000000000012, 0}, \
{0.5750000000000011, 0.01600000000000006}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.5750000000000011, 0}, \
{0.600000000000001, 0.004800000000000017}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.600000000000001, 0}, \
{0.6250000000000011, 0.009599999999999949}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6250000000000011, 0}, \
{0.6500000000000012, 0.003999999999999979}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6500000000000012, 0}, \
{0.6750000000000012, 0.004000000000000015}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.6750000000000012, 0}, {0.7000000000000011, 0}]}, 
         {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
          EdgeForm[GrayLevel[0]], 
          RectangleBox[{0.7000000000000011, 0}, \
{0.7250000000000012, 0.0007999999999999958}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], Thickness[0.015], LineBox[CompressedData["
1:eJw122k0VV/YAHBXEhKKlKhkqqRQKA3nuYTE3xgyT6WQmVDGJIQkCkmIzHMp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           "]]}}},
       AlignmentPoint->Center,
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesLabel->None,
       AxesOrigin->{-0.7250000000000001, 0},
       AxesStyle->{},
       Background->None,
       BaseStyle->{},
       BaselinePosition->Automatic,
       ColorOutput->Automatic,
       ContentSelectable->Automatic,
       DisplayFunction:>$DisplayFunction,
       Epilog->{},
       FormatType:>TraditionalForm,
       Frame->False,
       FrameLabel->None,
       FrameStyle->{},
       FrameTicks->Automatic,
       FrameTicksStyle->{},
       GridLines->None,
       GridLinesStyle->{},
       ImageMargins->0.,
       ImagePadding->All,
       ImageSize->Automatic,
       LabelStyle->{},
       Method->Automatic,
       PlotLabel->None,
       PlotRange->{{-0.7250000000000001, 0.7250000000000012}, All},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       PlotRegion->Automatic,
       PreserveImageOptions->Automatic,
       Prolog->{},
       RotateLabel->True,
       Ticks->{{{-0.5, 
           FormBox[
            RowBox[{"-", "0.5`"}], TraditionalForm]}, {-0.25, 
           FormBox[
            RowBox[{"-", "0.25`"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {0.25, 
           FormBox["0.25`", TraditionalForm]}, {0.5, 
           FormBox["0.5`", TraditionalForm]}}, Automatic},
       TicksStyle->{}], {576., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.39254536838916*^9, 3.3925528459713955`*^9, 
  3.3926272920495987`*^9, 3.392978259891509*^9, 3.393155202690096*^9, 
  3.40472999629275*^9, 3.404730336527125*^9, 3.4111235627090335`*^9, 
  3.4120614813747234`*^9}]
}, Open  ]],

Cell[TextData[{
 "Mean operates on lists of sublists by computing the mean of the ",
 StyleBox["i",
  FontSlant->"Italic"],
 "th entries of each sublist:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412061341293296*^9, 3.412061374591176*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", " ", "i"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.3925365935515633`*^9, 3.3925366237049217`*^9}, 
   3.3925451832128897`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "d", "+", "g"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "e", "+", "h"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "f", "+", "i"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.392545368609477*^9, 3.3925528462017264`*^9, 
  3.3926272922498865`*^9, 3.3929782599515953`*^9, 3.3931552028503265`*^9, 
  3.404729996449*^9, 3.40473033673025*^9, 3.4111235628993073`*^9, 
  3.412061483567877*^9}]
}, Open  ]],

Cell["\<\
The following Manipulate object shows how increasing n improves the \
approximation of the normal distribution, providing interactive demonstration \
of the Central Limit Theorem: \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120613903137836`*^9, 3.4120614681056433`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"H", "[", "m", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"m", ",", " ", "1", ",", " ", "20", ",", " ", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.392534320272749*^9, 3.392534337377344*^9}, {
   3.3925345167953343`*^9, 3.3925345197495823`*^9}, 3.3925349571184883`*^9, 
   3.3925451832128897`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 20, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`m$$], 1, 20, 1}}, Typeset`size$$ = {35., {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`m$301$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`m$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`m$$, $CellContext`m$301$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`H[$CellContext`m$$], 
      "Specifications" :> {{$CellContext`m$$, 1, 20, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {47., 52.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.4120614960057616`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.3 Lognormal distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.392545428455531*^9, 3.3925454338933506`*^9}, {
  3.4120615569834433`*^9, 3.412061558315358*^9}}],

Cell[TextData[{
 "If the random variable ",
 StyleBox["y",
  FontSlant->"Italic"],
 " = log(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") has a normal distribution, then the random variable ",
 StyleBox["x",
  FontSlant->"Italic"],
 " is said to have a lognormal distribution. We derive the pdf using the \
following code. Note that the second term in the second line of code is the \
Jacobian:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41206159300524*^9, 3.412061701831725*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", " ", "=", " ", 
   RowBox[{"Log", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], ",", " ", "y"}], "]"}], 
  " ", 
  RowBox[{"D", "[", 
   RowBox[{"y", ",", " ", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"y", " ", "=."}]}], "Input",
 CellChangeTimes->{{3.3925461287024364`*^9, 3.3925461863853807`*^9}, {
  3.3925477747192926`*^9, 3.392547787888229*^9}, {3.3925478308199615`*^9, 
  3.392547855825918*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], "+", 
        RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "x", " ", "\[Sigma]"}]]], "Output",
 CellChangeTimes->{{3.3925461675583086`*^9, 3.392546186966216*^9}, 
   3.3925477853946433`*^9, {3.3925478567071857`*^9, 3.392547880321141*^9}, 
   3.3925528462618127`*^9, 3.392627292299958*^9, 3.3929782599916525`*^9, 
   3.3931552029204273`*^9, 3.404730009902125*^9, 3.404730339652125*^9, 
   3.411123570910827*^9}]
}, Open  ]],

Cell[TextData[{
 "We call the pdf directly im ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120617249349456`*^9, 3.412061734739043*^9}}],

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.3925450015416594`*^9, 3.392545023693512*^9}, 
   3.3925478078669567`*^9, {3.3925479712819357`*^9, 3.3925480313683357`*^9}}],\


Cell[TextData[{
 "The probability density has a positive skew and is defined in the domain 0 \
\[LessEqual] ",
 StyleBox["x",
  FontSlant->"Italic"],
 " \[LessEqual]\[Infinity]:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412061743872176*^9, 3.412061788886904*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"1", ",", " ", "1"}], "]"}], ",", " ", "x"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "20"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", " ", "\"\<Probability density, f(x)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3925525584679856`*^9, 3.3925525970234256`*^9}, {
  3.3925526817552643`*^9, 3.3925526861816287`*^9}, {3.392552728672728*^9, 
  3.392552760818952*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk0ldsbB3AcuZVIpibXkHmMpFuR74smkmRORaZDGnVDhsqNLjImlVKR
ea7TLUWSORznLUdF0SVzxsNxiOr6vb8/9trrs/Zae+/n2c9eeyu4n7HxEuDj
42ul2v/7+5fchfQ8U40bPVq35vmv2FLXJm/pKB+Ekx88F2PbM4wXGyrD5eWj
sacid6osbdJYNKn08fKOJOwUrJdY/UgK96vi5JbI34HL1Hiiv68utCY94xe9
01AYvmb90wOm+CL64L+f7RmQ5Kvx2bFoDaWcZVsWfmSDq7OQ9dfUYZzc4X9q
Ti4filvmCndKeeGf9z1ZM2ZFqD/TPpfbdQoLJyy7prwfIcGH21GrfB7p/F3R
c7sYCNvMGDTXDMZO1nXl2fYnWMk4GLQtJAzDKXuqZ44/BR9hKXPeOAKxnr+O
cH88w8B46beEQ1Fo++GTzJErw78mPD/f14kIeCOrO8kox0ZdZrSR8Q2su/Ge
OW5WgfJv5sl3um7CXYOgjXq/RnBv9ieJk6m4UCRcNt1eg20nTwSN1WXit85e
1XG5JgRsav9N0P8xOqpe+Y8NN0FdWEX82D4GCnJSakcZzRCTfCAUp/AEVues
XEfMWlC/Jz7GseUf3FpWfmvI+y040rXWZVLPIX6vUWCqnQ3e3vA3dvav8EO0
NP+sURti2c7iJyUq0f9XpjUnvQ37G+OXSL+tRKn3pQeTx9/jYthI+QW5Kjjr
b94+8eMD/itVjRm4XI2HzWl+o3Kf4Gy12VSGvw4zKc80umM/wWLDnjK/g3XY
7c3sY89/wm7TW0u2p9dhjDZnX972Gcm9G9ZrbavH1h1W26Mju5Du9L6236kB
McKe3NCZLrgY+0/I3G/Av5+Cis66fQERTHr1dDcgIiBb1snwX+wqTl+61u0N
3j36KaA62Y3F0Vs/6m0aIY5lLiI6PdDxoTm2xDTCUCV5e6RnD9RTk9eE1TYi
fiafG9zagznBUlGBjU3YfP2Dl3vhVyRYrmznzDbB5cIx066vX3HRpEOxT7kZ
ka6jsg5reuGnJPoq17YZn7X5O8yv9sLXZJlJeWEzLjdrWei59uFJiLJ1hBUT
eYznKoU3+xAS+ceHqPNMsFNMacotfbiuIPUx/A4TSt5OFWu29cOou7TqdA8T
VlZ9KUln+uHz+a6Ft0ALAg1O+6/I6cfrDEaCt2ILmmkROnwSAxgZHhdJdG/B
zIiocLD5AErSpK9VhbXgd/adIe5lanzL993LHrTgbPqj9KGxAXj6TF7ifmiB
9I5O8bcNg9AyC+XdNmSBUKJP7v01iD9Ux7/M2bBwXHiKWaM/hIN5yoXxx1mo
+CR0tTR9CBXmNhZnklkYrLrupts+BJVdW1Sq8lhYmSdjXCAyjPaY1gX7Chbc
AzbN3Q8eRvjw32IuX1mIPfqqbTVjGA/nhaY/TrPwbOfex9eHhtH5RE8kg0Zi
qYTL8at23xD9rjvDUJHEpoXhXYvXvuHupSIHsU0kDn/9c0NQ9TcUs8dLzQgS
JY+iO0/qjEDqa7AX25nEiPhIrIXbCBIrtTfS6SRUAyyM1ZJHIJaRaxfoRyLd
SPhh3/wITGOCmOv+JtGVdsKmWmsUh9WfJjESSKyltdDSXEdRpljykEwhkdQU
S3euH4W7tMOGrHwSpNb46q3fR1GY4FZ3jEFCOHF/k5TmGDRHZFYWvSCxl1sc
zD06hk2q7CVRr0lEOIhqtSaO4URoeuZsPYmqstNfSmrH4B11u3OeSeKXzNv4
2NkxjCaxU260kgjoS5jac2QceZmuakmdJJ7s5mQoJ4zjt3erCxa6SUzmW9vR
asYxmS4txt9PQkuEseTrzDhe8czlcodI+Jxd9bxSdQI2+lY3J0ZIZLX5+dxz
noCiZLTap3ESX7ew1wbHTSDAZmeUD4eE7N1NTMeqCXSqNR55ME3C+VdSqAF3
Aq1Z/ntCZ0jcOsbVllCZxL7Gnl7aLIm2WttujtMk2AEjNVvmSIipPk0kYyYR
qPn5vPR3EpbXJE2LKifRfz7wchblqPHz3OipSew3UPTopeye58vWF+dAMItz
p5Uy3+d1hRmaHMyLVt7+k3KaMDN81S4ODJ33NzdR8xvvCDkS5sKBsdGROx+o
9btOaxpMBnJw2KCCnsIjEZzeKeJynYNUE994CWq/a9gxgy0FHGSa5dD3UvGU
0oxeG9ZxIKy2nNhKxWtnMHa74AsHjlXpXv1UPqbp986unePgN/ufMlajJK6n
WJpHiU3BccIyJ2CYhG7zT4U59SkY2AYYuQ5Q5/+jaMHLbAq7KpWllvWSWO4q
UmQWMIUQYcN92Z9J5CW+iniSMIW3M/kLdz6S2F1z6qhC/hRe2n9OtGOTCFcm
RRc7p1DAVeqRayKxwfHS0CneFByy2+o21VH1EaVT1SU6jUrWjaGVVP38HI33
KzeZxl/VPiu0n5Lwf3LgvX/uNHLT3ftE75GQ7F8s6q+aRkffjeGEm1S9SD2+
avt5GiPFc0J98SQmLoj9oSfCxVbe1o20v0h4o/XO2DkuCtfiuZkHlf+M2fLO
GC6Ux7L7bh4mkSIo09WcxUWw99KoGlsSjU102fyPXJR1pBmUmJFQs/uZ4bV9
Bg3rfN36FEgM+6gW/cvPQ/Gty+ZHO1gIY1qyWOt44L8p+GcBycIanXMTFfo8
yPgdet5Vx6LuR4VuqhcPcv+Id00/ZiH/os0zxyYehFp2buBFsuCbdLHyXeIs
AiRLHzbosSDAy+h+nT+Lrv2xqdkqLNx1bOR7VDMLxgDZ6beehWYZCbO4mVks
zxuebhNkQTM374250xysQ4+ebP7YgrGXbe9q5L6jlgzy+BzYgtMD6n1PS+ax
IZabL8Bgosfl09Lqpnl4JUjK6mUyYdsRpcPqn4d9iEOqw00mtjKHggbWLUDu
kQwtKogJGiNbTDpyAeUD7LNxJkykhCoYB7r+wA7tOC+vd82ollh7Z5vYL4xJ
F2SuH23CcoUI1e6tfIR0iqdPgxz1vogxNR4eoxGVhzLWGU3Vwb3T7jWtRYi4
NHY7z2WwGn71Ee5nVJcT8le2P95cWgnG2RW2a8xFCKuiQfvMx+V4GHJiRNdR
jFBpvqtyXuA5rqT9PDgztooQZntV18lQ/462HqIiWII4JfIr+QqDAZXz9At2
GlLE8hI/7c1jJejn3XYQfiVNCNkW9Iy4FMJiwPdikt8agm5zItdZIg9W/Yma
srLriJ6qU66zVtkYqXUPayxeT8T5LFV7IZEJnVUffzdz/Z0oEh81VFhIx3Lw
3Lq4soRbrZ2feMwD7Bl3nttgL0/0ujjoyh5MRUeNJ7+zlgIRLbXw7F5cCp5F
1bnI8xSIb5OSvX57b4G+xL+HJDcQGqtrL/4ukwyPcyHPVtxVJHIUDXdEWCdh
o7cmaemmRGgrVmyMrUzEW3EtYf9tykRclrpxzp/xeFlyJVWLpkLQdxaa1I/G
IIRfw7rliwrh7zTGOR4YjeVdwXtPP1UlBHmPH48eiMRAjkJyWqga8S0zJZAM
u4pktbWCZfbqxEu/hNjOl+FIvEt/4yavQTx6IT7AZ3wFzslHyRVDGsSzG9v8
qr+F4fvO7Pm0Sk1CS/Z6raTBZfQNmF6oidQiJtNeKoX9DEXGDr31LDdtYr/R
kYILzGAUX/Vf5a2tQ8xKOJQrTFxApL3HPhpPh+hcQTtgYRIIg66H+ZGsjYT2
Ac2SyNv+SFFPLWbt0yWunaY/DNM8j8tVcSn7ynSJzbUPGC+qz2H/evvsZiU9
Qn2v09tjoX4wOf3m8KpoPWK+2H3ku+dZpMm4K7Xw9AjV97s1U1JPQ6k295bV
4U1E9vhuteHyk0jUrtFgV24iDuw2MrIQOgE6V7C1SUOfeBWvFjF+4DjcGdPy
0Qn6RGnoh6taH7zR2Lw0vOKnPqH2cdf9aic6Tpp9TWyiHOTcMHiTslhF2YOP
lPm9Hun6UnYq9i3nUF6x9GW9OOWhhJYppV/6RLLXixkPRzqE7BOPxVGWCbag
CznQYda92tjlP31i43Dt7X22dAw6cvadoExwbSbkKF9713joAuVDrha7Zmzo
YFcH+SdRlnQ4N3OPsntWZ1EDZe37OY4TB+kIO562fuOiPrE1Pk3vujUdSr2B
6kaUf8k+jfei3Ohs/Yc5ZdP/dMe2URaz5Lf1oPwk0yOv9wAdaToe125TTj5e
pLyZsmmuYUoW5Yn9tL+XUh6Uk8xhUL4SWDPYZUWn7kN9NZPy85tB+Vcps6Pv
v+2gvCTKT9iZcoBAwJcByqPlrad0KK8LsRqdprxT++47AcqVXJX5Rcr9X5r1
2/fT8T8t930M
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"Probability density, f(x)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 20}, {0., 0.24197034683894927`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.392552846371971*^9, 3.392627292420131*^9, 
  3.3929782600817823`*^9, 3.393155203020571*^9, 3.40473000998025*^9, 
  3.40473033979275*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The mean and variance are defined in terms of the mean and variance of the \
normal distribution; the coefficient of variation is defined in terms of its \
variance only:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412061800583723*^9, 3.4120618462594013`*^9}, 
   3.412327061460862*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "%", "]"}], "/", "%%"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3925450015416594`*^9, 3.392545023693512*^9}, 
   3.3925478078669567`*^9, {3.3925479712819357`*^9, 3.3925480313683357`*^9}, {
   3.3925482558110685`*^9, 3.39254829785152*^9}, {3.3925483376487455`*^9, 
   3.3925483389005456`*^9}, 3.3925484312333136`*^9}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"\[Mu]", "+", 
   FractionBox[
    SuperscriptBox["\[Sigma]", "2"], "2"]}]]], "Output",
 CellChangeTimes->{
  3.3925455041343517`*^9, 3.3925478099098945`*^9, {3.392547976439352*^9, 
   3.3925480127215233`*^9}, {3.3925482569927683`*^9, 3.3925482993536797`*^9}, 
   3.3925483395915394`*^9, {3.392548432354926*^9, 3.3925484393650064`*^9}, 
   3.392552846462101*^9, 3.392627292610405*^9, 3.392978260131854*^9, 
   3.3931552030506144`*^9, 3.4047300100115*^9, 3.40473033985525*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"2", " ", "\[Mu]"}], "+", 
    SuperscriptBox["\[Sigma]", "2"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["\[Sigma]", "2"]]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.3925455041343517`*^9, 3.3925478099098945`*^9, {3.392547976439352*^9, 
   3.3925480127215233`*^9}, {3.3925482569927683`*^9, 3.3925482993536797`*^9}, 
   3.3925483395915394`*^9, {3.392548432354926*^9, 3.3925484393650064`*^9}, 
   3.392552846462101*^9, 3.392627292610405*^9, 3.392978260131854*^9, 
   3.3931552030506144`*^9, 3.4047300100115*^9, 3.404730339870875*^9}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox["\[Sigma]", "2"]]}]]], "Output",
 CellChangeTimes->{
  3.3925455041343517`*^9, 3.3925478099098945`*^9, {3.392547976439352*^9, 
   3.3925480127215233`*^9}, {3.3925482569927683`*^9, 3.3925482993536797`*^9}, 
   3.3925483395915394`*^9, {3.392548432354926*^9, 3.3925484393650064`*^9}, 
   3.392552846462101*^9, 3.392627292610405*^9, 3.392978260131854*^9, 
   3.3931552030506144`*^9, 3.4047300100115*^9, 3.404730339902125*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.4 Exponential Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.392632287642909*^9, 3.392632293591462*^9}, {
  3.412061855182232*^9, 3.412061858406869*^9}}],

Cell[TextData[{
 "The exponential distribution is defined in terms of its mean only; an \
exponentially distributed random variable with mean ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", 
    RowBox[{" ", "_"}]], TraditionalForm]]],
 " has variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Sigma]", "2"], "(", "x", ")"}], " ", "=", " ", 
    SuperscriptBox[
     OverscriptBox["x", 
      RowBox[{"_", " "}]], "2"]}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412061874269678*^9, 3.4120619554464045`*^9}, {
   3.412062113553752*^9, 3.4120621225166397`*^9}, 3.4123270663378754`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "xbar"}], "]"}], ",", " ", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"1", "/", "xbar"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"ExponentialDistribution", "[", 
   RowBox[{"1", "/", "xbar"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.392631874949485*^9, 3.392631914306077*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["x", "xbar"]}]], "xbar"]], "Output",
 CellChangeTimes->{3.3926323159536176`*^9, 3.3929782602019553`*^9, 
  3.393155203190816*^9, 3.404730024870875*^9, 3.404730342402125*^9}],

Cell[BoxData["xbar"], "Output",
 CellChangeTimes->{3.3926323159536176`*^9, 3.3929782602019553`*^9, 
  3.393155203190816*^9, 3.404730024870875*^9, 3.404730342402125*^9}],

Cell[BoxData[
 SuperscriptBox["xbar", "2"]], "Output",
 CellChangeTimes->{3.3926323159536176`*^9, 3.3929782602019553`*^9, 
  3.393155203190816*^9, 3.404730024870875*^9, 3.404730342402125*^9}]
}, Open  ]],

Cell["\<\
The shape of the distribution is unaffected by the mean, which acts only as a \
scaling parameter:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120619705080624`*^9, 3.412061997386712*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", " ", "x"}], 
    "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", " ", "\"\<Probability density, f(x)\>\""}], 
     "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.392631926052968*^9, 3.3926320258865213`*^9}, {
  3.392632083188918*^9, 3.3926320872147074`*^9}, {3.392632230210325*^9, 
  3.392632247545251*^9}, {3.41112696916728*^9, 3.4111269746151133`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVzns803scx3H3xKrNOhJl0/FIVunqODun+nyj00mbnQ4T042tKDnKOiP9
IkdOzpyzOOJYcxld6DZS6eS249JqLiOtdKGH6ziRRnIqyc63P96P9+P538uJ
f8h3n4mRkREH7/PnxvMtVu0lNizK82gwGPRwV0tnB9B5oCR2soTjejDcU56k
0w/A0n2UipcDesitkdDM6bFwxE3oP6jRQ8R60U/vaGL4odqVszBHD9qP+zNG
aWdh/qYKmZCphxkdvS4jtMvACdSGlMW8hoJGedQwrRxK/Jzs15qMQHGJuCPC
rREqhemehXOHIAzazr4SaqHawEpi5g5CpM6171bxM3hieYW5KkIHVk5JLl1f
d0OSPmnad3MfnCY3MQqC+4CUfybCKKYH+B3cf0ybBwCdKs2uFXRBlCqJf8hl
CDL/3k+K8uqE0sMkPzvvEaCzMwNe5z+DAuLg0MqAUWiXjpUJSE8gUT7149tX
YzAQpI3TdT0CI203qjo2DlF29XHcsYew+OfQo1zGBPQ8p7J3kNqgfyJru3X1
f6C0YLYFDbbAVl14XHrUe2jODVudeb8JOP1pSx0dJyFmgU+ek3kDDNXzE9SK
j1DinuOmKL0HbpT2hV57PoFDdHn4xvC7YAUTIZ3j01Bc9SnyenwdfD8S9G6R
vxH6d8DxC7u8Gnhat9c4aJkx2mx97XHscDWU/XZ3N33CGMV/aZjrQa+EUHNR
d0uLCXq7VaufEtwBgZAoI8lMUcaJwG12trdhRdjSFnaIGWJcuuoxPPMWtNos
sxYxzdFadbnCxvIGVBYnZi8ztUBb2kuO2QZcB8KYsa35hQVa40BKsd+jAKvO
Y1sib81AL1ODn08Kr4Cu0ClDftwSdTNatx6aKoKMJfPNyv1notJzwf3a9IuQ
Jgu9H0K3QiY5Os3xlPMQlLGrhTRohXylviqTqgJ4v+niB7nSGlmSeY8evZJD
n87zaF0yCXGfbJFwR3Pg3PpVDpqQWUihfTxvkZkMFL+KKGHLZyNxjI/shSQL
kv0FLNOJ2WiqPobZvysT3DsLLidr5qCy5Dsn6MwzIHXNVmhYZET+pep3Zfif
cKJGImWVk1F1PG3lSp9U8HHwv9joTEGyGxWzzrv9ARsj7++giCnomzg7Yb5E
DPIFfOfmCQo63Mn97tzkKXCuL/qLs8MG0Slid1FrEqQtr2M8VNogx+ueOba9
iRA6btbWwKAilWpOb+B0AvBL39DFqVS0OrDJJVITD+pGy5NVU1Tko/Iu0pQQ
EOHVk9aAraJfZR/BJleV57Vj5/PWjNthByrCK0axRdw7XnuLCRhMbR5z/kRF
+8wz3kxeI8DCPy1Ygp1glZq85AoBXl3zNuyepiL+9tjTSRcIGAgYZR3EVtqW
BDKwUx6oeUexN62zdn5wnoCHtbGidOz+oq+UDtj8Cx3X7mHzpDyjmwUEJByQ
O6wwUFFDZnNlTx4Bzr0xruuwPw6ESpOx1UHbPLyxeSEu0cuxyWxjPwF2Vp29
e2wuAXI3QUoWNqOlsYacQ4Bn0bfSC9j1hszC29m4jza3sBQ7cV2yZCe2G0VV
24QtVnfsviTDfeLc1qfYfmTw5mBHm0S/0GGzuOq1b88SYE9wht9g30yLcZJh
K8cXfzBgN9Wy5yDs/wEsKk4W
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"Probability density, f(x)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.3926319938404417`*^9, 3.3926320266576304`*^9}, {
   3.3926322435895634`*^9, 3.3926322477054815`*^9}, 3.3926323179064255`*^9, 
   3.3929782602520275`*^9, 3.3931552033009744`*^9, 3.404730024995875*^9, 
   3.4047303425115*^9, {3.411126976848325*^9, 3.4111269966467934`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.5 Gamma Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.3926366899631343`*^9, 3.392636695561184*^9}, {
  3.4120620073910975`*^9, 3.4120620087931137`*^9}}],

Cell[TextData[{
 "The probability density of the gamma distribution is typically defined in \
terms of parameters \[Alpha] and \[Beta], such that ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", 
    RowBox[{" ", "_"}]], TraditionalForm]]],
 " = \[Beta] and ",
 StyleBox["cv",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") = ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SqrtBox["\[Alpha]"]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412062027229624*^9, 3.4120621030786896`*^9}, {
   3.4120621336927104`*^9, 3.4120621628646574`*^9}, 3.4123270681604958`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", " ", 
     RowBox[{"\[Beta]", "/", "\[Alpha]"}]}], "]"}], ",", " ", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", " ", 
    RowBox[{"\[Beta]", "/", "\[Alpha]"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", " ", 
    RowBox[{"\[Beta]", "/", "\[Alpha]"}]}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   SqrtBox["%"], "/", "%%"}], "]"}]}], "Input",
 CellChangeTimes->{{3.392634482298669*^9, 3.3926344849224415`*^9}, {
  3.392634561342328*^9, 3.392634568843114*^9}, {3.392634600428531*^9, 
  3.392634736043536*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"x", " ", "\[Alpha]"}], "\[Beta]"]}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["\[Beta]", "\[Alpha]"], ")"}], 
    RowBox[{"-", "\[Alpha]"}]]}], 
  RowBox[{"Gamma", "[", "\[Alpha]", "]"}]]], "Output",
 CellChangeTimes->{3.3926367340865808`*^9, 3.3929782602920847`*^9, 
  3.3931552033310175`*^9, 3.4047300340115*^9, 3.404730345370875*^9}],

Cell[BoxData["\[Beta]"], "Output",
 CellChangeTimes->{3.3926367340865808`*^9, 3.3929782602920847`*^9, 
  3.3931552033310175`*^9, 3.4047300340115*^9, 3.404730345370875*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Beta]", "2"], "\[Alpha]"]], "Output",
 CellChangeTimes->{3.3926367340865808`*^9, 3.3929782602920847`*^9, 
  3.3931552033310175`*^9, 3.4047300340115*^9, 3.404730345370875*^9}],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["\[Alpha]"]]], "Output",
 CellChangeTimes->{3.3926367340865808`*^9, 3.3929782602920847`*^9, 
  3.3931552033310175`*^9, 3.4047300340115*^9, 3.404730345370875*^9}]
}, Open  ]],

Cell["\<\
Accordingly, we can express the pdf in terms of the mean and coefficient of \
variation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120621891023855`*^9, 3.4120622033729057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      SuperscriptBox["cv", "2"]}], ",", " ", 
     RowBox[{"xbar", " ", 
      SuperscriptBox["cv", "2"]}]}], "]"}], ",", " ", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     SuperscriptBox["cv", "2"]}], ",", " ", 
    RowBox[{"xbar", " ", 
     SuperscriptBox["cv", "2"]}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Variance", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     SuperscriptBox["cv", "2"]}], ",", " ", 
    RowBox[{"xbar", " ", 
     SuperscriptBox["cv", "2"]}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   SqrtBox["%"], "/", "%%"}], "]"}]}], "Input",
 CellChangeTimes->{{3.392636877673048*^9, 3.3926369763649597`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["x", 
      RowBox[{
       SuperscriptBox["cv", "2"], " ", "xbar"}]]}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["1", 
      SuperscriptBox["cv", "2"]]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["cv", "2"], " ", "xbar"}], ")"}], 
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox["cv", "2"]]}]]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["1", 
    SuperscriptBox["cv", "2"]], "]"}]]], "Output",
 CellChangeTimes->{3.392638778496298*^9, 3.392978260442301*^9, 
  3.3931552034612045`*^9, 3.4047300430115*^9, 3.404730347027125*^9}],

Cell[BoxData["xbar"], "Output",
 CellChangeTimes->{3.392638778496298*^9, 3.392978260442301*^9, 
  3.3931552034612045`*^9, 3.4047300430115*^9, 3.40473034704275*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["cv", "2"], " ", 
  SuperscriptBox["xbar", "2"]}]], "Output",
 CellChangeTimes->{3.392638778496298*^9, 3.392978260442301*^9, 
  3.3931552034612045`*^9, 3.4047300430115*^9, 3.404730347074*^9}],

Cell[BoxData["cv"], "Output",
 CellChangeTimes->{3.392638778496298*^9, 3.392978260442301*^9, 
  3.3931552034612045`*^9, 3.4047300430115*^9, 3.40473034710525*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density exhibits a positive skew. A maximum is observed \
when ",
 StyleBox["cv",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") < 1:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120622258552337`*^9, 3.4120623118789296`*^9}, 
   3.412327069872958*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PlotPDF", "[", "cv_", "]"}], ":=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"GammaDistribution", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         SuperscriptBox["cv", "2"]}], ",", " ", 
        SuperscriptBox["cv", "2"]}], "]"}], ",", " ", "x"}], "]"}], ",", " ", 
    
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "2"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<cv =\>\"", ",", "cv"}], "}"}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PlotPDF", "[", "0.25", "]"}], ",", 
      RowBox[{"PlotPDF", "[", "0.5", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PlotPDF", "[", "1", "]"}], ",", 
      RowBox[{"PlotPDF", "[", "2", "]"}]}], "}"}]}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.392637476063491*^9, 3.3926374859176607`*^9}, {
  3.392637564510672*^9, 3.3926375646608877`*^9}, {3.39263771367516*^9, 
  3.392637721556493*^9}, {3.3926377759446993`*^9, 3.3926379585372543`*^9}, {
  3.4047300562615*^9, 3.404730123183375*^9}, {3.404730255995875*^9, 
  3.4047302957615*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8l28Xtvf4Rr9EyCgroWx5nnNXKKWojAZCtrIlkhEiK2RTRmbLFqGs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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotLabel->FormBox[
         InterpretationBox[
          RowBox[{"\"cv =\"", "\[InvisibleSpace]", "0.25`"}], 
          Row[{"cv =", 0.25}]], TraditionalForm],
       PlotRange->{All, {0, 2}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic}], {192., -118.66252583997979`},
       ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3c8198Xx+09PkZkZMTXSkQyUp9zZYYUkkIqycpKSNGyZ/aeZWSPUjJD
tmRmRdkfPj5mZPP7/P55vx/Pxz33vs85r3PPvW9BCyeDB2QkJCRPiI//v1Nf
WFDJWHpifzen17g34pWb+gV0jQVuAXkxcjAJ8MUetdT5CAjYAuV2yfcyq3Is
U9TnUrphF1B8nCb5hqcXm1ofxk8p8BRaXq61N4jMYCVXLN8cWb+Ef/MtLQdv
/mLHmdIO94e8oV1sofRNJwkI59DK7+75wUxpLU3Dazqwv+jmsMUfBBVqNviE
PDb4ODCRtaEaCprcxXcE+3lg96Hu2Jp1OJS00fvlbZ2EDNKxoC31SOC7PXPH
hFMc1Loi//s3FAW6HZbHBM6cgfkEzYYN2xhQ/Cm8lecqB6GWB2Z/92JBVqPj
o7ulEpw583F7LSweNozMOy3oAPr3bGJW+ROBrF1O/8WXS+DeyndmpSwJyp2e
T1zS1wDu6IHOJdUU4NQZoXp2XRvqzIOtCT9T4ew9R++dFj2wkEDki9bpQH5n
4XzloD6Q7T3r3vDKgMLgsSNF/+swMGF0YkP9LfQnm8yfcTUGj0L6yvWhd1D/
I6CQkt0ctKPmqNYzMmH9nciJvZm7wOvRcH3NNgtWBPydVKctYPl2yrtV2WxQ
5pRi+U75AOpVn6yu7GVD+serKs+vWEOUuAF2pSkHRn/VmylU24Il8+nQ5bD3
MJDVedR31R6of02JLvHnQeSXp3lu284wXF/rRpjPg2qOhN6nL10gPyfh22JZ
PsivbDx/xuMKei56d/CqhWBImeP0M/oJCNwUL1pgKAIuqSsMI85PYf0ixd78
zyLI5AvcPWXpCXG0VXE46xL4+FI1fOnNSyh/ou3y+HgptDKWv3SbfgUpeAWu
v16l8J2s6YsEvTc49rBar6uXQboThbr8C19gTWkjWxv6APP/Qm2WNoNgj+lz
nvOFj+CjJtbR4hICM68zr61mfAS227xTp/ZD4bP1i7QV23IwFeT84ModASZn
5c4v730C2tJrTxkzokE1R3DS4e5nsG4Se/AuMgYkuZgDl5o+gyk74aAmKBYO
Dxd+EsIqwGrBujGeWAdvO9IfLfJXgj+765vrM8mwkfBJ4k9oJZxR4q1JEEoF
DevO6b6dSqiXpMW+t0sDAvmWUVV/FfSTOkyzBWaA4kW980EBNcDfPKd1yywT
Qugt/3pt1MA0P3ZRmCcLfo88LXS+Vwvlh/4cfeNZ4OuezXdTuQ4iqd4ntzvm
QE/JPpnoyleI69lxxtflASvQmjNK1UO5Ac7+dUo+KIvEnA+wrIcbAoNGM88L
4M1G3t9nvfUgPcP+6lCnCOQifz6wKGiAzL6RTb/gUnjZIaktc+cbSH3ka2Uu
KIfcsgqRgthvoPuDNo9X4RP0JVwi/+/7N+gychCcbfoEwtY3a44rNUHd3Uhs
8uxn6CD3lSJha4aD9DRhJeVK4Lj4i7W7pQUGeU/XLp+tg+KSoF/2Uh2gbZvX
wpneBHhWfKj2vQ5I8yn91PyvCUTdtbFiMR0wQxtdt6vXDBkX6N9O73SAT73F
/XWSFohqD7Uyae4EXzamwEm7VnCfDl/TNOsCSjK5SmqjDkin7/RhUe+BYJ2o
fZ3zPWANvYkEl354zMs0mVY5CCTv/lX9CukHpkuTZ9OXBiGBgnesI6sfGpaM
47MFh6Ct3Yovb7AfEHWwfkPQEIhd33/34PwA4OUpT/CZDMO8jWjhb9KfsFpx
TLN2dwTsop7X9UQMgv25MAEj+XFwnBWfLi8egW5qPKb0yyRMmI/QNLSPQNFr
zq2ivkkwHA6U6poZgYfhYwNxhElQ7MQ9neUeBYLhMogJTAF5WTaGI2AULkY2
+av4T0GClyD2yZ1fMOSV78ekNw0NbFyJSphxMNLkeqXVMQNyYW116qfG4bXI
HXWByRnIofKY0dcYBzojRcZfWzMQujMobec1DqJVW5PbwrNw409MS9L8OOTk
BXr1PJ8FfD5mY6/+N4ws2fO0i88BnaCv6B/FCZjZT8scssVB24VI6RfqE2DA
VYJ/4YkD/5tpCicMJoCZr+WQJgwHZBFfNE0fToDVbwaV5hIc7B4SrIdSJ4Ay
f+XM2F8cLI4Z5XaTTYIq9ZcQN/d5yN+2KHVkngQ7n4CPKv7zYMPu/IWRdxJM
XxeUrsTOw4xOcJvOuUkw+RdwuFo+D2NVdfOt1pNgc+3294C1efieICpe/30S
duTP/jy0XIDgcjmZOyOTEGf49diMywJo9agoHc5OQgN/Zkn+qwVooja7fOFo
EjSZdv78Sl6AGvcI2y8yUxDWwvS7q2cBiq7v5JXGTUFc7y2SFTk82DtTfbia
OQUGAvQT8wgPEqFsVcslUxB/4Qpdky4ecr6d7pBsn4ITaxZafJZ4SJO1wOfu
TcGz1wZNFpF4eIPplHh7dxpk79KVSs/hoVLhxCc9R6JunJXOHGt4mDF3gn3P
aahP9Hk5socH5SK268bx03Cuk750A7MI85fNnjP+mIZuLZXIV0qLwP6omLr6
1zS01zJuaKsuAiSQRNksTINuoCzpuu4ixM1l5XyjmIHaDvtrg3cWQdVnqfup
8gwk/hrQ3/FZBMd8MBG9PANLYfXR+aGLkNQbOTNwYwaapQc3FWMXYZVffkfa
ZQawLl5mS9mLkFbz4uRc7gwEUT2K/dy8CNubzG4GHLOg9EpwcvRwEYROWBwd
Cc1CsrdIvBUlAfTUyoOKZIjj6ndTeugJkB11M43myiw8XDuzCMcJYCD9trXO
ZxYaP7rTvpEmwIsbf/XtI2chJu9CDtM5AuQ9Vx/jSp8F3Y9HGo7nCUDyfWHV
tWoWSGxINjrUCFBkI8t9am0W0rVLc/aNCTAc7ps1fDgLdxy1GDzMCEBRMSjl
zzAHkudMlfvvEsCE0lN1UnQOnr2Qvy1uSwB/ya6uN+fmIOiHjK+wAwHKDPlv
XlCdg8fu9ONHzgSgeffNPt58Duo5hMONPQhwtv3Ylpr9HLCU6PENeBLAfNX6
9frTOWimPK0j85IAn7AMcVdi58CL9DghzI8AEw/MBfbezUGBT0F8WCABGMJK
83NL50Dnw+FVxxACWPy6/pX8+xy0zFLe7I8gAF3ypMOjEeL8n7EPdKMJ8MHE
kffP3BzodubR58YSgHw04GkVKQ4ae4+FUycRoDCRXUyMGUfMe3EmfQoBrt96
OxjLi4N848tf11MJkDVcdfaRAg6sbpR52r0lgG6C5tRvNRw4U65c33tHgA3j
gQhdAxx4bDPnOGURIIXzHlTdwYFqX3ZIazYB1IeWlkQdcEASanmS/D0BluOe
pcQ+w8FYpWDAyVwCxN2g1iEPxAFjb//gf3kEwHLE7DjH4kDNKVKKMZ8Acz8F
cn+/w0FsZkTBMJHfxBbd0C3FwQdFkYeBBQSQNzpPWVVLZJLmYN5CAvxmb/0o
2okDuZMHorFEDhgwtIgdxsGwlefddSKfiZnAkM/h4HIIjYFcEVFvQ4evzsQ+
EhgRyG1K5Fdsuw6/Seahmml3yIrIYv3+vLpM86Ad5JZrTOSeKLbOSp55eNok
mX+ayB4GGU9FxefBgNdub564vgDrabFY+XnYHwuvCiJye2/lIJnaPLimcFJh
iOwSqeHnrD8PhbGR+55E/7n1+8/+Np+HLYqsmi5ifI2Yu1M69vOw7kf3gJLI
dj2EiMqn81DsEssuRMwPa8RTEA2YB0M1cbwIMX9VV6mWY2Lm4WijloKFmF8L
5ugUsnfzIHjf3GeSmH/6bn4d55J54P0s6pdA1Kf8TeHOeM08KDVpictnEsBM
TylXp2Me2J+RhlcR9S3sMqAUnZ0HTtcQXo80Yj2E/fkYsz4Pfp8kfcqI9bGv
a29BRrIAFx9RiPcR6+fKd7+v49wL8OxmfGl7HAH+hbA66ogtwDuSmN6MGAKk
6aTzVp5bgLFDrdI7UUT9O748jbm2AKlX5/6LDSPqH6wuRma+AMdbnPbpifWM
1e4bdHq4ABat68wPifUe3r54Vsd/ARZV4h2mvIn6tfEtk9YswIMEQZ9Kd6J+
AQUpTu0L0Nf9r97tMVE/TUWd8cEFCPxyoMxD3H89Lfq5X9YWgEoea3eSuF8f
NftaOIniQSh8RvI/EwLwzWhQ/TuLhwE2vfLHNwjQSUab70Xsyzy1fLolBgT4
D4WtBd3Cw5n0D8eWtQkwUhX7KisED8VjZMuhxH6iUpqTNrKCh/Hsv6lWHMT4
fthcurtP7MsHui5RLARIXpKYm6NZBH+hmZ1CBgJsSpSc3hBcBNN+lZBiMmJ/
yq6oYbq+CPGywpFzS4vAktw2qvqFaN/3Zwk1LEJdZfCLjqZF4AvDSVhWL8LD
Yd2T+r2LIPF6uurJp0VoPtZra45fhEs/+8475y3C04iRbQ9eAszqpAfnRSzC
pB+eo/gVAcYmBboNzRahzJnB8PjlJYgqHzihuICH70lsT4tuLAHfzU/5axN4
mGviTr9kuQQvhBZepgzjgZtLfNH+5RK8rNx/2dKKB98GdZ+GT0tw7HuSslM2
Hm6wvvxod3IZFLQ4AqTM8bD7cY2tdm+Z6Mc7S4WWBXjr+RB/xngVTDBzV78S
z+cz9bTbAbdXAfeYSdyJWOf1FLmUf+6vAktI0d3jFvMwETYjEOa8Cr7r4ReN
r8wDX8Zt44WgVbCqE10IFJqHpKarTW9rVqGtaiG16wcOohjl0lhPrkGP5gm8
pSAOvNP39TcIa6DfG2bX/v8+3z+Bap79hTNLn1LC5qdAxNXK47rEJvhsMj4I
6v8DM5vxN+hr/0Er/9jT3LejoD1r9zzq0TZg+bacBhJ/gt5MxCk+vl0w8br5
q+VGL3w/NTNgJrwLs7Vmn8W1ekHnscKLZIld0OvLW4lV6gUtst89xxV24XYR
xZNg3l64JHDKne3aLrDaaBVOT/XAObPmehrvXfjwueOs0aMe4B3YMfo7uwvT
ZNPhehLdgP9m8aqtaA+WdxasGFY7gT9y2O5N+R40RJhXa//shOvmekbXq/dg
XlW4IrWqE+q2lSQm2vZg4bSG32u/Tog6zTKwNb0HPnwfUoG3E5Tjv4qKcu9D
6q/z799c6YBQO95uP/990CblEL74tQ2kWAZPqN45gJjbn9Jmx5phLmzOO/bB
AfTNuP5+3tYMqXRbONzDA6ge7RYRKW8GBorjH0I9DuCkqmBZTkgz4P/d0hiM
PACfS8vtVsrNkD027mjbdACIoLnyK7UJeHNnv4aLH8L4ncmgu47fgA427439
PQQh+rKtI+UG8FARo/m8ewhJh5wfN8UbYE7VtDic9AhSKtt/7HE2QKNWw+4l
5iMIuLCwp7hRD88MwqLzJI5gV4D7yK2oHhYf/Nfsfu8IXsKG0trJevgeaiTG
0n0EjjK+ly8R/wfOhwf+wP88AmULKw5etjrIjax2bRo7gp/mBX/Z/taCb5xg
wxP8EZS8Xg26/bEW+Hr+Sa6QkSDRZJkeo3O1MDjS2GzER4K6g71F2rA1oLlk
snXSiATRhJ/Z4beugjR2n/6XN0lQ4XhSLKdOFWwoF5SMmZIgzSSjd+LSVZAR
vGcdZ0GC0G/JupStStgVTRmmdSZBpYUVozVBlVBoMV65GkyCZn88iO3/8AUw
w3e86upJkBDd7a5+zgoYbrQkNZEkRetilDt7YuWwqjLK/VyaFBlH+L52YS8H
6oarchmypOh0+urm3tFHkP963npOkRRR+ZTaaA59hJhqTJeLOikSjBabqvP/
CFfLaxJCzInzBwxShRY+QEs2+5naCFIUv8p34151GfwWDr48EU2KxH829nLl
lcFm5pEFeTwp2hTgfjIdVwbC7/Cxl1NJEaW8FU2+Sxl4p9Xv/cwjRUeN0e1k
p8oAG2/futxIivwNzQ4H00rhU2CTucAmKZLlr/ph8l8J5Gp3Hg/YJkU+/tcX
RMlKIImhr29pjxRxNbA84/pTDK8i/mhUk5GhQn8FL9vEYuJ9Y1fqBoYM7VXa
eFYyF8PU+zNHIafIELiesj0gKwKm1pT0rXtkqEqNU02JvABIgzJvmT8gQ+9X
MW3GM/mwoZ3P1mxDhhxjK0bjmvNh5EdFQJQTGbpeZiPnHpgPWYN9Tqefk6Fk
LwOPz8z5cH6OBt1PIEP1qQ5eQsJ5YEXpNvHjBxl61ur+cPb+e+Dmbx/a6yVD
wy/NnrzXfg8/FE90i/0kQx+vZzd7y7wHefvmWu9fZOjih1M9vkc5QNV/LFl+
ngzdT1yULk/JgeyMz0ZppORIv2JoqvBXNswob3c4yJEjJ3raR04PsyDBSLcx
SYEcLeXllEobZYGuU0Zl63lyJKpa7EcFWVD+TitXUIUcFc6opG2xEv/XaRP9
fl4hRyJu6ddmqzNBeEgJXbQmR+b294XGWTLhvovnJ4YkciT9Q7m5vOstyMv+
/iSeSo7Onr9g41P1FujW0WeNDHLUam1n9eD9Wyh9RFXxKoccXbA8LnX/9VvY
d478svGBHH3RZyRTk38LcU7vq8c6ydGv0jtvQzIzoN2+v6HwgBylsL9geMqZ
DimS8o3tJBToE6XCYf5mGjgTEhrnyClQdFbe46P+NOCwN/8mQEeBdJ8f2jJH
poHFw4WmGA4KxENIoW9jSIN926NWL2kKlLrQWviKLhWkrU/90L1HgYQEHEoU
+ZLhty2/U5ElBSKfbazZPUiCUHs2DJMNBQq8k78wMZ4EC4/29LsdKdDcgRsT
V1oSZHp1/tT3okBN6duv5ASSgDPq4fiNeAqkwUG4tS2RCEc1BYS7XUR7t+Su
mlvxUPw1PayhhwL9df0VU3sxHswao6VODlAgP5I2rt+C8VDZ6uk8PUqB2ugd
h5/j4+Bxn87Gg3kKZEqYjJR7Hgc43OKeHTkl6tDqSrXIjYVuVkl6NyVKpM09
f22GPQawDg4LyRcoUeJ/ZQIXD6OhuLW4tREoUdt04OliXDS88ZLxxWhQIpOL
gWnDVdGgOyd/UGBAiUY6tVV1LaKho1JlZeohJUoJCKFO+hQFzXeN+6+lUSLZ
F4P80g6RIFedUPbkLSVaDLyfZXErErKOjYanZVGiS4T6sAL1SPDtMNMl5FOi
0GRGped8kXBJzqI5oIISGfKSpp7ojYB6aoeKuh5KNMm5cQadj4DqYu9kSXIq
dEyxi3dX/g1Q6Rpxx1NRoVGvfVp/ljegvyCaSEpHha7IBSpjCWGAE+qKG8RQ
oQ3D57my78KALZEz6hUfFRJL+nNbBBMGD30KAweUqNBU0owL80YI8NwcdPNy
pkIJ+8p1maNBYLWZuzH3mAolf8EI3a4KgrIoz8f6T6gQhX0B/cWkINDsEngk
8oIKPZzcqHYyCYLHlx7a94RQoaKiXELyWCB0SpLcF35PhehE5KrwuADwJJW4
9n2cCmXSHFCpcfnDnBr9sMgkFcrYZec9OvCDa4GEO69nqBDv1auOo1N+IMxc
4iS/SIxPoPH8WqEffOeVC8/YpkIcKmXhyZf8gE8R+8OVjRoVy1K8anrsC42O
BronLlMjnxxvi6cEb5D8cHbgiS41Ir80oroz4A1xm+xmfVepEZI8IRFb6w0P
vYYeBtygRm+TNAMEwr2BPdgsZO0+NdLlhuPeZ73BKtuqo/kFNepTpEo3ev0a
6MaeaTmWU6OljA0qhzOvQP5JHmN4BTViUM2//+bEK7jHOtxXUkWNXHWC5pvo
XsEXrXO31+qp0Q+1TsGpjpdg9WnlkWsXNTrXWTDkr/ASGt5YJj+bo0ZaVbP8
z46/IJ6/esv+x2nQCwlN+fEtT8ga8/r4nocGPfkRcpxjyBO6nxR4tPHRIA2D
lMPHnz1BpJiGnO4/GiTsZaSQ5uYJ/dzfOMNkaJDfohJD7uYzkNpQUInWpkEm
1+10nfafwmyOYEy6Fw1iChBXaRLyAILv5A75K+L6fYciyxQesG7x9o6NDw0i
PbWHwc49ARJ+wVMywTTovCEeezXvCXDHCzQ2xtOgCxuDp2RlnsC1AP7V2Q80
KFEtU2ZA0x1qrE/oSi7QIOaxzp574a7wTX28LIJAgwTVpC/vuLpCh1Aq5+YK
DeqsDA0pM3GFoT+807X/aJC3VFOfj4grrBvzPrtKQYsuOLjLFXx9DGJaPLku
/LSouZSOZ2bLBWLEuCgqjWhRuOLvvIMXj8DMXOT99E1apDg2cjBr+wiEY85q
M5nRokv+H1fmrj+C8qMrEfctaJHGNXqQPfUIBga9eZmcaFGX7EzE4rAzsPkR
5O4H0iI2PlefXkVniJr8+oCxmhZN5+QP2rA5gglnF41iHS16/XU0fnfZAU5e
GS2waKBF4oRC/ooOB/jwZWOtopUW/daNbyzxdoC+cPEXFgO0iP/WNd6kDXtg
wUbHVSzRojmaW3viEw8hIsmq9Z4AHZILULfcGrCFJ+7ej72E6BApSZqHyGdb
MDdI448XoUOf0wbOP423BUm6wSffJekQTk1QIsjEFtqfqospKNEhVZYLVnpT
NkB2SziIwYAOmT7681B32xrcOKe0K3zoECEdm8980QrM/h786/WnQykl8ol2
J61ArZsrkxBEh1KPMYXNUFsBa4D+nmAEHVI7MN2W638Axf/qC0JT6JAKX/hx
tYcPYP5nOoPFJ+L4na7ugwxLMIm5/YMBR4dcb7nhtwXvA+9HOp6HeDrUqZ/j
f0RzH/70Vli3L9Eh2xyn4f9WLcCSmZXUf4MOrQbHkfbWWYBjcMvZI1J6VESd
eS71tgV4v5JOXOOlRwrjiJWQcQ/y7EktBw3okU3d8PL9i3fBPqS4VO4GPXrr
c12PS+wuSOWbHkTdokdNwsFjC6x34QPuU9zVu/SookX9sKL3DtRY2LW3OdAj
bLv2E1LJO9Bzs1+qOpAe6eaoMtzB34Ztteyd9Dri91oY/EJCTcGrOt2nqYEe
vcaYGn6wMwUS2STGhSZ6dM0uvYD0silQ84cLynbSIxkLdSwXlSlw7Hhcbhqi
R2MlJD9FvE3gbJFu4vwqPVJSRl+iX98Cx2MbijJCDMjQOo/jRYoxrIcsNxqJ
MCBK82sE85fG4Ea2oPtMnAE9L5HqsrAwBq+V8bvfpBlQioEqY7+YMYS0twYa
XSDaR2Vw6VfcgNznycNPjRjQe3b1sIxRI5ieveTRGMCAfOwFTr9Uug6X0n+8
kwhhQB6v+2TM+K5Dxk2Trqg3DGho61uTGfl1MO98dPJ+LAMiLWmZaO0yhNHS
jO/kmQzoMTpiULE0hD7PQwH1OgaUZfCtOSHeABpZqtpbNxgQlVosxScOfRDs
VN+Q3mZA0roYjdKja/DKt5cvYY8B8Wh6/myfvwbYrfnHNmSMqL0RqRpXX4Oq
MU4+WgwjiuH4ITZ07xp8eO/mon2KEfkdy7oaY3MV3l2U4em6x4g0hfSND37p
QqMenc+eJSOSsUtgCa3Qhak703hxG0a0GuXRrRmtC0LesVX+jozofcDcc3Ud
Xchq2bmFPIlcf6PDsFYHsq82JnyMYURvnUNY3+RpQ+49Q46kVkYky2std+yt
FrS5SL5o62BERxgN6YnXWjDvQzn3r4s430r7T6+FFojlVHwyHGBEGVmbmWL/
aUEenseIcZIRcTznLk0r0IT8xzPRr3YZUbFVNKXfVw0o8nNjsT7NhDxoH+Co
yNSBcOG2t98ZJnRU1Zo9hFMDyQ21v5lnmZDZYZFZW5ca5Fuw/5xQYkJyefs8
tElqkAsfE0w0mJB19HoDuZwaZO2s8uvdYUK/Rg4v1TqoQpKDvdS5SCYkOEdw
0thSgVHh6+mGMUzowfHimu4JFeAaU8a4xDOhjeDiSNcOFUjQpl8vTmVCytGT
1zBpKhArmv9JLJ8JBRq/iQ7VUIGISdwF3m9MSOfatIBXCoIAo/s65JtM6Hpu
MHftZyy8uzpm9mCbCf0T4v3yLxQLNZeNHFv3mFDy0yOMzX0srF/UjAwhY0bH
JfP7VjFYMBM5NcSGYUaVc5jqKMeLILu1biF8ihmNDdo9Hj17AX4neD9Tv8eM
qKQjqdNmlGAnai/kvSUzGqgT57rcoATsYa6ptDbM6NhtIy+hNCW4/NqqvsuR
GdkWr8GDm0pQbqtNdcOLGZG+V6Tl6FaE4POsUVbxzOihqwTtdpMCnBt7mxfQ
xYwKMzQ1xXrPAUbKZrukhxk5DX2d1/x0DggvpTSH+5nR2c9Yv+DEc5AlVD0j
NsqMJPUbyT0szgH7wwH+jjlmdKlY7NHKphzsepHrUJFg0JfyFt9TQnIwQi/f
oMWFQU4bnQZ1sbLQIpc4P8aNQTJ052aXnstC+e195ke8GNTzOfmxspUsRJQ0
mifyY1ArZ+WqtIIsaBle3V/4D4PqO8H+2agMfEmyUQiRxSADy8ItNxEZSBBP
LurSwSClw2Im8Rxp2Pirke1zBYN2+ht7uJ5Jw9W69RSlqxh0RkJhQkNPGqgM
tUOzDTAof0ol6/qWFLh57dg9v4VBOavTZPK6UmDQbSx22hqDPlw98aKT5DQw
uLFnhnpjUFJ8h4BMtATYQH3SJV8M2hyhyOBwlIBvtPZR234YdJNHj136sgQ8
S/v22jIIg7J9ttu3jsRhodXl7oUIDDq7XXE44SQOLdy9JwipxPhhwnj4phi8
rA9L0KnEoADVipykKyKAH6+P2anCoA5o+bomJQI39v5GvK/BoDjXLkMXjAhI
ypsEkddj0I1f/ZiV/v9guEDkWXULBq1SfcL3mP0HsvFfTU8NYFCUcJ8Ftbsw
zDms8dGvYFDBhJTbUNNJ0A8R5qlcxSAPniWP7fyTUJNrzGm9jkEpgomJFyJP
QvR0LfO3TSLXDrqfNj8J6FYwiec+Bj3vWo0s3BGEJDWhKTwtC4p9XxG3LS8I
V3iMsjuEWdBSMLecZDQ/JMxI1ZuKsKCd9XdBbnb8MFNE84sgyoJWPFnj1lX4
wQvVYJhPsaBuuole/zU+KHwg5GUow4Jer+JHMIZ8QFe6ZjB2kQXRt//Rc+U/
Aa1qb0iWb7Agaef4y72/uIGVyYbn5U0W5OvucJG7khvMh1TkMSYsxP2hbBse
xw3/bDcfyt5mQQLv40MO9LlBJNxsyP0+C2KYYT6c6uAC3xGJ4iMnFmTILRSc
2XQcVBxbTVmCWFChnh1pxCAH7A4vaDQFs6Dne48mvD5zQLkqg+yTUBYUPNki
FhfHASJc+jTj4Szo3vfv5FeMOYChabQ8N44FzWpRmTSPHoNhrmVGlMWCfPIl
UdECOzg3s9c7fmVBp0mF7bv/YwOJMwoFgg0sSH6KcGaUjg2mk27FDTSyoHj7
Oku6VVa44Zxmf76FBcX0yFwZrWKFCzxiXFRdLAjFYpNkDViB5pGyS+ooC7rD
cawtMYAF0nkthL9vsiCPbdPfG/QYOH/2lJTFFjG/K70jaUvMMHB5Q2F7mwVt
kdltBH9jBpon/jrC+yzoxM8FGmpnZnDuzXfxImNFZyOUWQM6mQD5/62XZGZF
vrX/Ru1CGWFqxfd2mBgrOnbvi/jGWXrwotKzFpJgRd757izUGHrgOMH5qPIU
K8q+MdelRaADbe0831kpVsR3p3TAOJsOPmR1FVw8x4pMaHQSU7nowOcWx+6S
CisyvnxsKYaOFoS/vY/TM2VFf24r7eYyUMMPye2sMTNWdA+si+qXqcAjTuuj
nTkr0kAXyw57qKDTdqHb/x4rUr9VvECIpQIXzCnar9asqOydzlSoIBV8vV3s
Ke3Kihi4fYbLgBJMtsvvYsJYUWrMWq1BHDlQWFA6pb1hRekfyBR+eZFDcafR
c8kIVpTLyGXpe58cSNP/JWpFs6KJxB05RRlyyFVX7H+VyIrq7S8oCP4gg82o
avW1bGJ8BRsRPxnJIOJ0o0RfHStybwH4kkkCuYqmtN71rOjUXGShXCgJfFXd
wMk0Etd34VzudSWB5Vsi2ZHNrOj1E3klRw0S0PEP5tf/TlzPvZvbYPAIS/XH
gL1nhBUZ/jtXR+Z2iPWMmD7o2mBFqw7+UpJ/9rBRyV5jz/8R7X+9mPlYsYfN
zzlWfXqbFWWEjwy5ROxhh2s0PcL2WBH9bQ6N2Et7WPmFgnVdMjbU//wXmWXe
LnZVxRXXycyGePL8TOdf7WCt/lL0tkuwoUdlKQnJRltY83y1H2aSbChI7Y9s
ufwW9sY9386V02wI/5+56ibnFlajm7zlmAwbMvt6/t/K6D+sSAFZ9T0FNkTj
zbjfYPEPO2tBkr2jyobOKTaeLHy6ibXs2/MQv82GxF8kvL/07S/WLEjZvcac
DZmSyafS5v3FXkeej6/eZUNjVDR762/+YtWKdx3c7rOhNILKRUnTv1jh4B2L
Bls29EpZgU5ucx07rbKle8udDdFVSS+7SK9jLcrWBYLC2ZCJz5JscPUqto3W
c/liJBv6UJwU4pS5ij1tQV6zHsWGDHu+X3gSsordZmU3NotjQ+pKFTiC6So2
3PVcmHQqG3r3Z/PK8P4KtkbBY+dnPhvSsWqtPBm9jD1Wd9B7soUNDfCUWHks
L2KfcfinD7WyodkIjyrRlkXshCOTQ2g7G6r9MZSBSVvEFvLz0/z7zoZuS65M
hOktYi+9Jl6d+9kQBbmizekPeKyjmk++0yQbelop11nts4Bt66Dxqdkn+tMV
H0Kph8Paq05GtBPZdKOVlPwKDoupqUwbJPKZJ0w+JLo47M0iu6pVImNKxnL2
LuOwuPDva8IHbCi4wfnxujoOS2UUcTeMyKzXmASmLuKwqn84seaHRP3Zhr61
n8Zh54xXdR4SeQqDT26TxGGDe9pueRB5zI7iZespHLav4albFJE1ja9YNYvj
sBZZvwpbiHz14GRlw3847CvbdB7pIzaUtODqVHMChxWeeiJ+gcgzhc1b1bw4
bJvJNYXLRL5qxBFSzUP0X5fU8D6RweNTXxUXDpsudT84nsglu+Ozlcdw2Evv
lROyiEz7S6Clkp3oHz97ThmR787dKatkw2GlWJobOokc+7Ynt5KF6F9Qavcw
kSXuk36qxOCw7mTu47NEvvRY8nslMw7L7am3uE7kOhP95UomHLbur8jOEZGj
3jnxVDHisP8D34qbww==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotLabel->FormBox[
         InterpretationBox[
          RowBox[{"\"cv =\"", "\[InvisibleSpace]", "0.5`"}], 
          Row[{"cv =", 0.5}]], TraditionalForm],
       PlotRange->{All, {0, 2}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic}], {576., -118.66252583997979`},
       ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns803scx3H3xKrNOhJl0/FIVunqODun+nyj00mbnQ4T042tKDnKOiP9
IkdOzpyzOOJYcxld6DZS6eS249JqLiOtdKGH6ziRRnIqyc63P96P9+P538uJ
f8h3n4mRkREH7/PnxvMtVu0lNizK82gwGPRwV0tnB9B5oCR2soTjejDcU56k
0w/A0n2UipcDesitkdDM6bFwxE3oP6jRQ8R60U/vaGL4odqVszBHD9qP+zNG
aWdh/qYKmZCphxkdvS4jtMvACdSGlMW8hoJGedQwrRxK/Jzs15qMQHGJuCPC
rREqhemehXOHIAzazr4SaqHawEpi5g5CpM6171bxM3hieYW5KkIHVk5JLl1f
d0OSPmnad3MfnCY3MQqC+4CUfybCKKYH+B3cf0ybBwCdKs2uFXRBlCqJf8hl
CDL/3k+K8uqE0sMkPzvvEaCzMwNe5z+DAuLg0MqAUWiXjpUJSE8gUT7149tX
YzAQpI3TdT0CI203qjo2DlF29XHcsYew+OfQo1zGBPQ8p7J3kNqgfyJru3X1
f6C0YLYFDbbAVl14XHrUe2jODVudeb8JOP1pSx0dJyFmgU+ek3kDDNXzE9SK
j1DinuOmKL0HbpT2hV57PoFDdHn4xvC7YAUTIZ3j01Bc9SnyenwdfD8S9G6R
vxH6d8DxC7u8Gnhat9c4aJkx2mx97XHscDWU/XZ3N33CGMV/aZjrQa+EUHNR
d0uLCXq7VaufEtwBgZAoI8lMUcaJwG12trdhRdjSFnaIGWJcuuoxPPMWtNos
sxYxzdFadbnCxvIGVBYnZi8ztUBb2kuO2QZcB8KYsa35hQVa40BKsd+jAKvO
Y1sib81AL1ODn08Kr4Cu0ClDftwSdTNatx6aKoKMJfPNyv1notJzwf3a9IuQ
Jgu9H0K3QiY5Os3xlPMQlLGrhTRohXylviqTqgJ4v+niB7nSGlmSeY8evZJD
n87zaF0yCXGfbJFwR3Pg3PpVDpqQWUihfTxvkZkMFL+KKGHLZyNxjI/shSQL
kv0FLNOJ2WiqPobZvysT3DsLLidr5qCy5Dsn6MwzIHXNVmhYZET+pep3Zfif
cKJGImWVk1F1PG3lSp9U8HHwv9joTEGyGxWzzrv9ARsj7++giCnomzg7Yb5E
DPIFfOfmCQo63Mn97tzkKXCuL/qLs8MG0Slid1FrEqQtr2M8VNogx+ueOba9
iRA6btbWwKAilWpOb+B0AvBL39DFqVS0OrDJJVITD+pGy5NVU1Tko/Iu0pQQ
EOHVk9aAraJfZR/BJleV57Vj5/PWjNthByrCK0axRdw7XnuLCRhMbR5z/kRF
+8wz3kxeI8DCPy1Ygp1glZq85AoBXl3zNuyepiL+9tjTSRcIGAgYZR3EVtqW
BDKwUx6oeUexN62zdn5wnoCHtbGidOz+oq+UDtj8Cx3X7mHzpDyjmwUEJByQ
O6wwUFFDZnNlTx4Bzr0xruuwPw6ESpOx1UHbPLyxeSEu0cuxyWxjPwF2Vp29
e2wuAXI3QUoWNqOlsYacQ4Bn0bfSC9j1hszC29m4jza3sBQ7cV2yZCe2G0VV
24QtVnfsviTDfeLc1qfYfmTw5mBHm0S/0GGzuOq1b88SYE9wht9g30yLcZJh
K8cXfzBgN9Wy5yDs/wEsKk4W
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotLabel->FormBox[
         InterpretationBox[
          RowBox[{"\"cv =\"", "\[InvisibleSpace]", "1"}], 
          Row[{"cv =", 1}]], TraditionalForm],
       PlotRange->{All, {0, 2}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic}], {192., -355.98757751993935`},
       ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1Xk41QkXB3Bb2XdvIwlFjD1kjKjvL1KjxTQqhBYUpdIySVpNNSMhy1hu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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotLabel->FormBox[
         InterpretationBox[
          RowBox[{"\"cv =\"", "\[InvisibleSpace]", "2"}], 
          Row[{"cv =", 2}]], TraditionalForm],
       PlotRange->{All, {0, 2}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic}], {576., -355.98757751993935`},
       ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.392637852554859*^9, {3.3926379106483936`*^9, 3.3926379590680175`*^9}, 
   3.392639014525691*^9, 3.3929782609129777`*^9, 3.393155203931882*^9, {
   3.404730092464625*^9, 3.404730124558375*^9}, {3.40473027460525*^9, 
   3.404730296933375*^9}, 3.40473035066775*^9}]
}, Open  ]],

Cell["\<\
The skewness is proportional to the coefficient of variation, such that if \
the coefficient of variation is small, the distribution is approximately \
symmetrical:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412062319309614*^9, 3.412062368249987*^9}, 
   3.412327071725622*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Skewness", "[", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      SuperscriptBox["cv", "2"]}], ",", " ", 
     SuperscriptBox["cv", "2"]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.3926393929097805`*^9, 3.392639403535059*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", "cv"}]], "Output",
 CellChangeTimes->{{3.3926393968053827`*^9, 3.392639404035779*^9}, 
   3.392639501766309*^9, 3.3929782610531793`*^9, 3.3931552040720835`*^9}]
}, Open  ]],

Cell[TextData[{
 "The gamma distribution includes the exponential distribution as a special \
case when ",
 StyleBox["cv",
  FontSlant->"Italic"],
 "(x) = 1, ",
 StyleBox["i.e.",
  FontSlant->"Italic"],
 " when parameter \[Alpha] = 1"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4120623739181376`*^9, 3.4120624272448177`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"1", ",", "\[Beta]"}], "]"}], " ", "\[Equal]", " ", 
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "\[Beta]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3929782847472496`*^9, 3.392978345985306*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.3929782907458754`*^9, 3.3929783016715856`*^9}, {
   3.3929783324658656`*^9, 3.3929783590040255`*^9}, 3.3931552041121407`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5 Multivariate Distributions", "Section",
 Editable->False,
 CellChangeTimes->{{3.3931542631891603`*^9, 3.3931542660632925`*^9}, {
  3.412062437890125*^9, 3.412062442827224*^9}}],

Cell[TextData[{
 "Often, random variables are not independent but are ",
 StyleBox["correlated",
  FontSlant->"Italic"],
 ". To handle such distributions we require multivariate statistics. We will \
only consider cases involving a pair of correlated random variables, so \
consider bivariate statistics. As we might expect, the most common bivariate \
distribution is the bivariate normal (Gaussian) distribution."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412063344473728*^9, 3.4120633521948304`*^9}, {
   3.4120634639054623`*^9, 3.4120635622568846`*^9}, 3.412327073317912*^9}],

Cell[CellGroupData[{

Cell["2.5.1 Bivariate normal distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.393154271030435*^9, 3.3931542778302126`*^9}, {
  3.4120624553552384`*^9, 3.4120624568573985`*^9}}],

Cell["\<\
The bivariate normal distribution is defined in terms of the mean of the two \
variables and their correlation, \[Rho]:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412063320369067*^9, 3.412063336562352*^9}, {
  3.412063567163941*^9, 3.4120636168754225`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}], "\n", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xbar", ",", "ybar"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["\[Sigma]x", "2"], ",", 
           RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
           SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]x", ",", " ", "\[Sigma]y"}], "}"}], ">", "0"}], " ", "&&",
     " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]x", ",", "\[Sigma]y"}], "}"}], "\[Element]", " ", 
     "Reals"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3931523746335506`*^9, 3.3931523871515503`*^9}, 
   3.393155171605398*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "-", "ybar"}], ")"}], "2"], " ", 
      SuperscriptBox["\[Sigma]x", "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "xbar"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"y", "-", "ybar"}], ")"}], " ", "\[Rho]", " ", "\[Sigma]x", 
      " ", "\[Sigma]y"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "xbar"}], ")"}], "2"], " ", 
      SuperscriptBox["\[Sigma]y", "2"]}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[Rho]", "2"]}], ")"}], " ", 
     SuperscriptBox["\[Sigma]x", "2"], " ", 
     SuperscriptBox["\[Sigma]y", "2"]}]]], 
  RowBox[{"2", " ", "\[Pi]", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[Rho]", "2"]}]], " ", 
   RowBox[{"Abs", "[", "\[Sigma]x", "]"}], " ", 
   RowBox[{"Abs", "[", "\[Sigma]y", "]"}]}]]], "Output",
 CellChangeTimes->{{3.3931524921725636`*^9, 3.393152552990014*^9}, 
   3.3931531209166527`*^9, 3.39315493490504*^9, 3.393155761443544*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xbar", ",", "ybar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["\[Sigma]x", "2"], ",", 
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
        SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]}], "]"}], 
  "]"}], "\n", 
 RowBox[{"Variance", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xbar", ",", "ybar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["\[Sigma]x", "2"], ",", 
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
        SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]}], "]"}], 
  "]"}], "\n", 
 RowBox[{"Covariance", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xbar", ",", "ybar"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["\[Sigma]x", "2"], ",", 
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
        SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.39315520495335*^9, 3.393155225242525*^9}, 
   3.3931552838568077`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"xbar", ",", "ybar"}], "}"}]], "Output",
 CellChangeTimes->{3.3931558617778177`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[Sigma]x", "2"], ",", 
   SuperscriptBox["\[Sigma]y", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.393155861807861*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[Sigma]x", "2"], ",", 
     RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
     SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3931558618278894`*^9}]
}, Open  ]],

Cell["\<\
The joint probability density is represented by a surface. This can be \
rotated in mathematica using a mouse, or other input device.\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4120636343605647`*^9, 3.4120636866657763`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]x", " ", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]y", " ", "=", " ", 
   RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", " ", "=", " ", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["\[Sigma]x", "2"], ",", 
           RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Rho]", " ", "\[Sigma]x", " ", "\[Sigma]y"}], ",", 
           SuperscriptBox["\[Sigma]y", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", " ", "\"\<y\>\"", ",", " ", "\"\<f(x,y)\>\""}],
      "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"\[Sigma]x", ",", "\[Sigma]y", ",", "\[Rho]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.3931571016005955`*^9, 3.3931572171467423`*^9}},
 CellID->20649],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XXd0VcXXpUhvCghSpIkiRZRqKMlBpIuUiAiKiFQFEZHyo/delCpIk95R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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mgn4D9UXxufOnfkJIYU22aUsZUmW+kcLSfum3VaWSChpVShtWrRv2hXS
vodKIiIU2iPSnvZSWv/vp/d6nu957jtn7sx35s6957znnNuw//AjTs+zLPs1
Zpl+2Qk6KAUWCXcV/l3ysHAntT9KpgifXWbZVhVZ9ouOzxOuI/yHcHfJP5In
1edc6WtLv1HH3SR/S56Q/hzde6siy/oJj1afLdXnZ53bW+1kHV+r8+er3VrH
f0p/gfA2wn8JnyNcS/hX4Qq1t+j4YPXvouPfJDN0z3+ku0myr/QXqd1e/XLh
o3W+mtq56nOx9PWl30zHlwg3EK4sPFGSq9/J6nOU2s11/IrwperTSH2q6ngv
6TdIHpJ+gvQNpa8i/f7S/St5SvoLpd9O+iD9GOFthRnc/wl3kdwRsqxQ32ck
A3RqjsZjXemxu1d4sfAS4YPUvq7rtlaf7dX+o3OfCO+j+/0gfKx0h6nP+2qb
SX+32j+l/1G4i9oNkkeEZ6v9uPT320XXLtRxffXtqnaj5DH12VX6JcLNpG8l
Waxn3EH6A3XdqzreQni8cD31q6TjZ9X3fR1/oXs+J/yB8JfCCyWf63ic+h8s
3XL1rS98QO7v/Jzw6cw19TlcuGfuefS88J5cK5kuvELtT+pznXAPsORZ4Rek
+0j3/VrHh6h9S/dqIP13zKHCc+x5tR/q3FfSHar2PfXZkXdUO1zn3hI+hDmk
41nC49RnB71XoeMJOv+Ujq/U+cuEn2FOCl8q/LTwROHGal/T8Vkao2bCO0rO
Ff5Ico3Ot9E9PxC+SnhX4ZPVdxfde77wJcJPqv8V3F9tY/1vDZ37UP2vlq61
+lwufRPpt5D+CuGmwjWFV6jPhNzfehzfTecu0fE30t/J+0v/lfAdwl2E1wrf
ILy7cHXmkq75gm+aew29IDxS+i0qPO5fq/9ktV2lv0J9n9O563S8UvpL1e4k
/ZXSPy/99Tq+mPEWvlz4cuFnhScJjxd+XPgy4RFqa+j+nwkPF64u/Cnjknvu
3K57Nte79Y6et02kWyW5SvgG/e/1kjaSDtJ9L7lP+sZqP5JMFK6v9j2+D8+s
e0yWjFD/ndWeIPmBeZhs2kyeX+eGSXaTnKXnqVnhuTVdz9xccoP6dNTxD5L7
hceqT131ibq+nnTvSiZI30jth5IrhV/RdZ+WXv8tJOskN0nfNvc8vVO4de71
cYdwm9xzc7Lwabpuc93/fR2fpP94EjuhZzsy2UzszzD1qaY+H+j4UZ1/XDJF
fZ7U/+5WeEya69wnkhuFd1a7Nve77IctlDwqPEt9V5d+t5GSp3WfmtKXrC3J
QOG6uu/2klOEc7WfZ7aHj6jvbupzj/DNus883Wc+9kp9HpbcI3lc8phkmuRB
yVS+H9eqfVRyt/CJus9Om54t97plze6V+u8puVX3/il6Hu6n9+6k46k6/pU+
rGnpe2MvpTtY+LE0Jg/o/C/8N7aBeyZ7O1m624Pt7tHS7xHct7Nkd13XSVJd
uJZkS8aecZDulGh7+4Ta3dPcm57ek3eckt7r/vTe6O9Vn1rqOw/fmPo/lPQz
0lhdnHntYxfmJ39xVGH7hq/pIzxHeEvdY67k7ORrekv/cma/1quwLcXWrkv2
Fv/Yo7D9xP8elOz/gXr+QyWN9N81mVOS0cmP768+04TrCC8WHosdFp4WPWZb
C78h/fjkN08UflH4JrWv4ht0r1t4D2ximsNPRb8z4zE9vftD0tXV+Usy+9yT
dM1Lwn2Es8Lfq4Ham3U8JvmaE3Q8W/hWta/peAG2V/e5QPJ1stvHFrZjrNNj
CvsR5vDkNI83Mv66rpf0H+n8Hup3W2By67tKegv+Dw4BL5H+RJ3/Q7iH9Mey
VliPwv/yPryf8EmsdekPSmP1u3B34SOF10Tb/BuEc/3fYcL1pBsm+VQ46B5P
SvrAMdTnk2ibf4TwWuFdsFf6r8/U9pecIP1G+AX31P1eYS2zDoUX8W2w/8Jf
FZ5Xx+TmHa8J76/z3SWPC8/U+VWlbeg/zFe1J0p/uHQfRNv2P5mf0h8r/Ifw
DOFjhK9nPqrfIzo+jnvAg7ALajcEr8fj4RfRfgefuEbXbKNzlYV/k74bz4bf
Fu4ofKfO3SUZJbyF7jtHclbm9fRIWlP7SLc+Nz85Qtc9LLlP+sOjr6H/z6zl
3Hbg1uBvu1+6z5Rkc/ZQ//XBz0B7V258S/A19O9Y2s6g20H9T5Wsk/461pz0
U3Kv3XvT+j0avhPtW7/D/uX+Rt/TJ/f8uZa1on73Mf/gI+rfIfM97kv3mcQ6
0Ln70/1nJFs6Tfp9StvPk3Jzrjcy+6nusolv40N5P0mrNJZ3p/GsqesWqd+X
wjsxx4S307kvsYO5v90o4Z6SGsG8sTU8R/js4PnHWmDeTUtz79DcXJ61f1hu
vv9Smp+/l54rPwbPkQMy89VM+v2COWELuAo2lrGFL2ZeaxtLzzn40zHYm2Ce
9rb6/K4+A3W+0PvOVp/+2Arh54RPFg7Czwvvp/7XRK/7fqzN0v5ss8KxAGt/
d/W9k7Wvfn+r3wvMZWxsYV7UV3iAzkf1m6Vzp7B+hWcK19T5GqXX7IvCa0rH
AHCK4wvHSj8Fr8uewn11/u/S67zQ+QWSI6Rvpz7fZbaxA/CxkguF79L5hoVt
4+W6582SITrXSPdoWPpbNVA7T33OEC4l3+IHEPW9QdJfus1y2+PB0jeV7kjm
vfBgXVu5wr6kCTGD5BvsHrGLzo2IjnX6JW68tfq9JblAuLbaZcmX4XP/LG0H
axWeY9goYrotscXB9vyv0rYVO/lHaVtTR/Km5Hz1P0/9r5IcxzzLHevg44ao
b1U901L8t85Pgrcnn7U4rfe9dP529Tsr2j++kXzZS3qWtaXjwJeJk0rHrqzr
L9S3vfo8Jf07pbnRDmqX6fgu6Vvm5l+3Cv8q3c+F7cYfzMHC/qu++r9ZmP+c
F7yesNGPSfd2ac46Vnih/qup9EN1/lTJ99gi6VeW5qytcvO426R/RPoVpXnk
6cG89Frpn5b+3dJ87iHhN4XfEZ7B9ynNQbENeyf7QJz0dYqVtpduqfAkbBF8
v/A9H1a7vDRXPifYNuOPdpb+jtJ8+37hJaW/0456j/HR8+w+6d8oPQ+mCC8t
PT8a5P5WV6jPIOk2qzC3+FF9Wum4PXyM2Ee4I3ZVEoM5ZQX94Sg6rqq2muSw
YNvFXOoVHLPwrY8QHsMaCI5fLlLbONi+fVnYtrTU8bvCn0kK4fGSZpKvsJ9q
TwjmDO/ofK3Sz9FX0jt4LQxWOyitz5OxI8FrZ2Dw/RiHtnq/VYX9CevxF/wQ
9op5VzjWIDbcEM0l+aanBevXF7Y/rXU8UjI8ON75TvqW0rfV8T/MOb4n45OO
f8Z/5Y6f4GlPBHN3eHtrPc9duvbB6DzMwYV5PrEzYz6R78xcLs3t8aEz4Bhp
7jKHWb/v4zd1TUvhHXLPNWzRy9KfI7yN8Gjd5wHd52zWofAU4dHYBfim8AXC
7+FPsfXqfy68UvrzWdvCDwqfy9wTnip8Xm7O811pn/SOrr1Z7c6JR31fOo4l
7lyc+Am5jvWSG3PH9d+Ujm9XBce/bRKn+qF0HLtE+ovUNpR+eXDMytp8Kziu
bZL5uk+jY+c3g+PXxsLvCt8i3Fx4aXBc3zDxpW8lN+l4lN7lfmwRdghbnjsX
cb70D0k/JtmER4UvFp4IVy39nhfBzYXHC1+ntpW+5XZ6jgulf1jH46SfxLyW
flu4SPB/wp2uUp+ZpZ/vGjhy6e/3SfDYwDEqVfi7T9e1V6vPrNLfpnnpNcD8
/wxfKNxO/UcU9rnLhc/A5qnfmeo/EpsnfAZ8Mbf/xt+dSdyJb5LulZQzIl80
RvoZ0o/NHb8eXjiGnShdMz3TVth+4Z2Eaws/I3mrcH7pSul3lH5L6a4VbiG8
Dc8vvLNwHfy8cHPhraP5+S+l+d8XwRxtj8wc9dfSceCrwXmIbTPntMjf8Jyv
BM8t5vaLwXmUOplzbl+WzrM8F/wdtpL+meB32lJ4fnDOYzt8SppjrMfXg/NG
dYU76B4fFI4rFwTne7bHL0vfpDTPIrf2Rel580LwXKiVOT9WSn8g/4lPDY7d
quSOuYeqT9Xc8dZpzMncuVJiw1N1XZUKx5+zguddbZ5Hum/1PEfj63PHUsOw
Lzr+t/D83ynZyBHYitw51znCF0p/oqR+cJ6Y99oXnlA4BztA+F98p+QXycxg
20Das5dacp/zM/vhvLQvhj//KLkbjlSaI+GP4DwfCtcMHquPhWsH8+efSvPs
z4I5dafM63Jl9Nonvvi5NP/+HG4uvJv0nwfz686Z45QNpfMIzwevXR1my4Lz
fI0YB3hdtO8mh/lV6Vze7GD7VwkfHbw+oLnPBq8DPWr2ZPBa4bXJT35dOq83
J9j+VYarJLu6mfC8YBtZVXhhsM2ohl8u7Rfxia8F29fNpZ8bbDurMCf1h++V
zjd1Lf09+BZwpiY8X+aYgNiAGOHxwnOAfBr+vRdrKzP/3F8fa5Huc5N02+bO
JzRVuzw3lzggeC7DY5nv86LtITk6fNc12NLCsShxTVPpmjMWmX0ePmd85hzS
x7l5FLkf4lNyKfCDDsH/1SKYK4/NnI8+Lvr++HpyFPjrJwrnwMnjcf6Y1Id3
Oiq9F7m+9olT8f+7p2d4v/D65H1+k0zTcxwl/dTCnIn+d8A9c3MqbN7gxPOJ
y7pqrFaynnPHpK3T95wdbU8aBnMU+AnrhvUzPDNHmRD8fnCTi4PH6cxgHkE+
nLFfmMaffEXn0jkpaibkmftlrlE8lTsvRwxyXOHcJjyJeK5vZtt7WOHcGlwP
zse125XOF/G/jdNzjpT++hRH8EzEAn2T3R4dze/7pTVeNXidM6+IP4k3g9pq
ko2Z5w/xC++ZcS/GOPN/jU12rLqe7aXc8/PaxPPHBedM2mhsO0TbvLHp2VYU
zp9vyFyjIXY4P5hTkZtan8a2RZoz3RI3Jo6Gf8KH/1vLOj4kmPvUK82ZmRfk
A8kFEgvA45YlLndA6ViAeUldBf4PZ6tbmldv+o5N0zynX6c0h4kj7ow+Xlaa
Y4/TcaXEe3kOciPEX4em79Yzfbvahd+T73tatD9gbtyIPdP4dI2eE3BncpU1
sP25vwU8lxgaG763dN/k5oTE87w/fK+27nN96djzd+mm586LUhNiPbAWeM6y
8P3bCLeTTNK5ydJ10TO8jp2SvJj73fvnnjfEj2sLx4f90zMTY/Ne5GMrFf6v
2xNX3zk4P7ZPdJ8DyDfwzqyj6GPwXmr3jMn+BK8x5saC0jnDHtHrrEFaa8QP
W6X37VE6P4YN5NnIh2wrHPXMT+fOdeP7eBb839i0Nrg/8UOz9H3b6j51Cvfv
WTo2JF9NbFIv/e/oYO5/ZFpT1dM8P0i4Z/R3uVDtmOi45A6epfS6YEw+LRzX
N4q+hv59c9cYl2V+vzHpvxok24JfPj/dE/1thb8x3xd+uy75R/6LPC9rZERu
vrkmc06gWvqO+GK4B/Z+SOJ75GrIIU+IfjZipEFprTGOvdNY8e746nXMt9Jx
1vHBmDnNfCbmR8e44qOIsxif3bA90c9MQRretxrbBYeOzgkPzc0ZPxSeD4ct
/V8PCG9T2uZjN4jr8BFfp/XAGA7PzaM/Zl1Ejxdj1Tv15/lp+yRMDYk4jfUO
x1iR/N3wpMcv4AfnRnM/xubSND7wh+1y+5pBuWt37/JfuWvOSzLnBsgRYOfh
oYuS76Bu1TT5XHwceQrs0pDUHztGTElsiZ8aljD2qk/uOvZSxrC0/eqQrhuS
/quZ+twV/R41k+/BtlCPJdcExpfNiuYn1JzJO32S2UfRHzw4N09/L/N8H52+
O9+E2ij41Nx8//3MYzYijRvxK5yfOHcudqB0LfbM9Ezcn3wWcTi2HS50tc5f
kObLyWnOUDMkd8k3+li6+6JjGXKW5PypX1xQODaBl96k4xuDuStcaLfStTlq
jPAY+APxErlo8tNn6ny3CuegqQHBV+Aq1KquCc69tE3XwqmoYzK2nGunvqtz
55HwA+Crg20ItvS6YP95abDdJl93S/QxeQXi+i2SXWG9k/dgDK5J4wDH4x6s
ofbqu2+F35+c363R48a7L5fUy5wjeADfrP73pHEj30udq3N0nYJ6CTYe+0be
qUXheiJc7IrgdT815XY4hiNRb71K+LTc8dlH2PxoDkO+98porkLODD61InEq
+B7XMT/xM8RE2Ey+bf/0fcldT0y+vnaaY5v8HWPFXLgumkuMT76JehXrjnoT
OXI4ABwQLghXHJY7dlylPot03BIbLXxZWr/kgR5MOZnLscnRz0wu5bY0tpcF
53z4rnxT8rH0JUc0tDQ/gBvg77Fd5HnrBHMwYhxsFfz76rR+r0xr+ZJkA8k5
ketrWbiOTO6uleTmzLnEtoXryNRf+uM71f/vzDyMnPkAxkayt47/Ut89NDf6
6Lh7NHeAH2zOmivs688Q7lRhrkBujtwAtjpIv6f0A3XNKOHOxJC5a7hrcvs+
5lJ74S7BuXdy7r3SM1ADIP9Prr5K4brScblr6QuFj8+95+J14WNz79NZkNkf
4m/wieSEd9S15zK20g2R9GCsg2NH6m7kHslzkeNaXThmxPeT995WeFDSt6sw
h4CrMlZrM9cUKheuc8FX4arwTGoB1QrXyMg1N5AcrfPdojkDuUy4DGsSPsOc
ea+wDSEnDz+CF7L/oWPh3PKhiQPwXuxPYv8Pa458ODwKX8q3YN8OfBS+XUlt
jcy8g/1RrE04Nc+6IvP+J7gfdgDOcHZ03AEfgkfBDfAFHSscd5FTJLfILc7U
+TOwGTo4N5rnk8N/Vf/1een9UtRBquv4hMx7RToXzl1Tl6lRuB46PJqjHpjW
APnSi9L9N095hgG597m8nbk+EgrXDf9K474h+eXuaX7C7xgPfDHcnzwCOYQb
dd3c0vUb1gs5amop5M1ei87dsZbbR69L1ij7QDqltUxcTxyIjaIOQoxKzmp+
dOyPPaH2gH3lvajbwsvhbNSdT0xzgJpT3TRujDm1qxbRvg2/Rr4UH8reLfI2
1JTI1SxM3Js6Nnt7BhSe8+z5OaVw3Zb9b4cUrnuy/+3QwjVccoYLovOW5MoG
Fl5H5FdfjM5xkXskH0eOi1zrS9F5KvK0c6JzU5Vz17XII5GnfTk6N1U1zTnm
Gz6zZfKb5HtnRufH7hZ+vXQ9Bt9NjX4x8zR3LY7aE3nLYYX5KvnDZ6PzZuQV
n4vOp7H3pruOH8zM80dF+zjmXv/CeUhyXLPT/CGvtYP0QzJzSPgjfPU2/GTh
Oj7zpHr0XCKnejoxW7Ib1HP3D85bPh+dZyOvOKRwXbV1dN0R+9kxOgYlJiPH
+0J0Do19PkdKXs2chxxamMuR2xxU2I7h79pF750hz3lqGh/ymacV5mYVuWuY
2CX2QHaTfmrmvYJHCz+Tea9UJ+FbsPO5n43YihpW+8J7k6gT7V54T2bfTTY/
c16og+SBzLaZ/RjY56mJu8BbsANVgusN7IEhzoT7rQ72FW0zc+yhyd6yf2Cf
wns72Ue0b+G9juz9+1/hvZfUy6gj8x/sD9yz8D5J8tWrovNv5KJXR+dp2bfT
LnEkfFVXyT6Zn5P9Q/iXfrn3XfIdyXV/LLxn5r1PPSrsh/bN7ZceTz6wcrLt
7APcq/D+Vd6ffVX3ZN5DyP7ITXsj95M8neZSWWGbSA2R/TPsP2F/CHmQfpn3
PtUrXMdkD8z2knMy71Fh/wpxCvth6heun45KvoO5jc+lznV4cN2wXeE9YNTU
qMNtqsHtVHhvG/XBNoX3yOFniNXxNeQLyAv+57uDx45xG5h7z+A7mWt2zQrv
T2M+j4yuX1ObYg8MnJ19DsTVxNTUTw8svB+SGnfPwjkl9qM2kVyW2U8cFRyP
n5M4DWPCXpTGhffgbVG6Xs5/sQZ4VzgFNh0bOSLZkEaF99Gxr4t9iuyjoD7y
UXReF+5Brrhb8B6M7/AvmfdLfBtdZ6fOyJ5VeCk1bDgBfICaGvwKX8Telb+i
a/0/p3mPff4zs63DvpETZ0/epv14u+qayzPvu9ulcH2TvTd/4z8y77tlb9+d
aQ39Yxf2X66O+iC5GWIQ9oWwd4L9KuRWyT+Qy1opmZe5FkcekRwUsQb79Nj3
AtdiXy7ztVKyyTwvuQF4Eb4Vntm+wvlZ/E7b6JzzKblt4Mpk09pEx/isC/Jz
2Df2Gx9ReC/0vdG5U7jxZolX4JOnRMcLzCv2c74RXZtj/+rS6Bof+z+XRNfI
2LP3W2k+Sl4VW8u8ol4wNNle9tC+KdxK+kFqB0fHYnBU6lCsf/bfLouuRRLX
kMMnZmOvbffgvTpcNyRdyz5Y9kizv5e9qez1pb7A/tV3o/P/8ON9g2Ocyon7
wZepfZD85xy8YnPJqazB6Pfn3fnPbul/qVmzd5r8IXt71kfvdWGf8NvJZmZp
HOFm7Il9JzomZS8hfJjYdk0wp+bZOufeD4v9/z98M8UE
         "]], Polygon3DBox[CompressedData["
1:eJwtmgf8V9Mfxu8995yfkVFUtmSmlBlSKqU0kDJSCWXvmaSshhklWkoysndC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         "]], Polygon3DBox[CompressedData["
1:eJwt1nm8TnUeB/DnXtmXijAtliJNljQTkUTDhKylLOWiCNlF2bNmKZSstygp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         "]]}]}, {}, {}, {}}, {
     Line3DBox[{266, 1, 262, 243, 949, 16, 963, 31, 978, 46, 993, 61, 1008, 
      76, 1023, 91, 1038, 106, 1053, 121, 1062, 136, 1071, 151, 1081, 166, 
      1094, 181, 1109, 196, 1236, 247, 268, 211, 264, 252, 612, 212, 613, 213,
       614, 214, 615, 215, 616, 216, 617, 217, 618, 218, 619, 219, 620, 220, 
      621, 221, 622, 222, 623, 223, 624, 224, 817, 249, 269, 225, 265, 253, 
      1136, 210, 1122, 195, 1107, 180, 1092, 165, 1079, 150, 1069, 135, 1060, 
      120, 1051, 105, 1036, 90, 1021, 75, 1006, 60, 991, 45, 976, 30, 1234, 
      245, 267, 15, 263, 251, 458, 14, 456, 13, 454, 12, 452, 11, 450, 10, 
      448, 9, 446, 8, 444, 7, 442, 6, 440, 5, 438, 4, 436, 3, 434, 2, 818, 
      250, 266}], {
      Line3DBox[{949, 1233, 625, 948, 1440, 1137, 950, 1441, 1138, 951, 1442, 
       1139, 952, 1443, 1140, 953, 1444, 1141, 954, 1445, 1142, 955, 632, 956,
        1446, 1143, 957, 1447, 1144, 958, 1448, 1145, 959, 1449, 1146, 960, 
       1450, 1147, 961, 813, 1148, 1234}], 
      Line3DBox[{963, 1355, 1511, 962, 639, 964, 1451, 1149, 965, 1452, 1150, 
       966, 1453, 1151, 967, 1454, 1152, 968, 1455, 1153, 969, 1356, 1512, 
       970, 646, 971, 1456, 1154, 972, 1457, 1155, 973, 1458, 1156, 974, 1459,
        1157, 975, 1460, 1158, 976}], 
      Line3DBox[{978, 1357, 1513, 977, 1358, 1514, 979, 654, 980, 1461, 1159, 
       981, 1462, 1160, 982, 1463, 1161, 983, 1464, 1162, 984, 1359, 1515, 
       985, 1360, 1516, 986, 1361, 1517, 987, 1465, 1163, 988, 1466, 1164, 
       989, 1467, 1165, 990, 1468, 1166, 991}], 
      Line3DBox[{993, 1362, 1518, 992, 1363, 1519, 994, 1364, 1520, 995, 669, 
       996, 1595, 1276, 1277, 997, 1603, 1333, 1334, 998, 1596, 1281, 1282, 
       999, 1336, 1337, 1604, 1000, 1365, 1521, 1001, 1366, 1522, 1002, 1367, 
       1523, 1003, 1469, 1167, 1004, 1470, 1168, 1005, 1471, 1169, 1006}], 
      Line3DBox[{1008, 1368, 1524, 1007, 1369, 1525, 1009, 1370, 1526, 1010, 
       1432, 1527, 1279, 1011, 1280, 795, 1278, 1220, 1312, 1012, 1438, 1584, 
       1241, 1335, 1242, 1013, 875, 1221, 1283, 1222, 1315, 1014, 1339, 1244, 
       1338, 1245, 1586, 1015, 1289, 1290, 1597, 1016, 1340, 936, 1017, 1371, 
       1528, 1018, 1372, 1529, 1019, 1472, 1170, 1020, 1473, 1171, 1021}], 
      Line3DBox[{1023, 1373, 1530, 1022, 1374, 1531, 1024, 1375, 1532, 1025, 
       1376, 1533, 1026, 1427, 1585, 1243, 1314, 1313, 1027, 878, 1285, 1284, 
       1223, 1028, 1587, 1246, 1247, 1317, 1316, 1029, 1287, 1288, 1286, 1224,
        1582, 1030, 1292, 1293, 1291, 1321, 909, 1031, 1342, 1343, 1341, 1534,
        1429, 1032, 1377, 1535, 1033, 1378, 1536, 1034, 1379, 1537, 1035, 
       1474, 1172, 1036}], 
      Line3DBox[{106, 521, 107, 522, 108, 523, 109, 524, 110, 841, 288, 111, 
       891, 347, 112, 844, 291, 113, 350, 525, 114, 295, 526, 115, 353, 527, 
       116, 414, 528, 117, 529, 118, 530, 119, 531, 120}], 
      Line3DBox[{1038, 1380, 1538, 1037, 1381, 1539, 1039, 1382, 1540, 1040, 
       1433, 1541, 1295, 1041, 1296, 1598, 1434, 1294, 1225, 1042, 1428, 1588,
        1248, 1319, 1318, 1043, 888, 1298, 1297, 1226, 1044, 1249, 1250, 1320,
        907, 1045, 1299, 1300, 1238, 1322, 1601, 1436, 1046, 1330, 1331, 1329,
        1542, 1431, 1047, 1344, 1543, 1439, 1048, 1383, 1544, 1049, 1384, 
       1545, 1050, 1475, 1173, 1051}], 
      Line3DBox[{1053, 1385, 1546, 1052, 1476, 1174, 1054, 1477, 1175, 1055, 
       1478, 1176, 1056, 1430, 1479, 1177, 1301, 1426, 1480, 1239, 1253, 1178,
        1252, 843, 1305, 1179, 1302, 1227, 1256, 1323, 712, 1254, 1251, 1306, 
       1599, 1180, 1303, 1228, 1260, 1437, 1590, 1181, 1259, 1257, 1352, 1607,
        1182, 1057, 1481, 1183, 1058, 1482, 1184, 1059, 1483, 1185, 1060}], 
      Line3DBox[{1062, 1386, 1547, 1061, 1484, 1186, 1063, 1485, 1187, 1064, 
       1486, 1188, 1065, 1435, 1487, 1189, 1304, 806, 1262, 1324, 1190, 1240, 
       1583, 1229, 1265, 1325, 1191, 1263, 1255, 1308, 1387, 1589, 1307, 1230,
        1268, 1326, 723, 1266, 1258, 1310, 1600, 1192, 1346, 1345, 1349, 1606,
        1193, 1066, 1488, 1194, 1067, 1489, 1195, 1068, 1490, 1196, 1069}], 
      Line3DBox[{1071, 1388, 1548, 1070, 1389, 1549, 1072, 1491, 1197, 1073, 
       1492, 1198, 1074, 1493, 1199, 1075, 1591, 1261, 1200, 1332, 1602, 1264,
        1201, 1309, 1231, 1271, 1327, 925, 1269, 1267, 1353, 1390, 1592, 1311,
        1232, 1275, 927, 1328, 1274, 1272, 1354, 1608, 1202, 1076, 1494, 1203,
        1077, 1495, 1204, 1078, 1496, 1205, 1079}], 
      Line3DBox[{1081, 1391, 1550, 1080, 1392, 1551, 1082, 1393, 1552, 1083, 
       1497, 1206, 1084, 1498, 1207, 1085, 1499, 1208, 1086, 1500, 1209, 1087,
        1270, 1394, 1593, 1348, 1347, 1395, 1605, 1088, 1273, 1396, 1594, 
       1351, 1350, 750, 1089, 1501, 1210, 1090, 1502, 1211, 1091, 1503, 1212, 
       1092}], 
      Line3DBox[{1094, 1397, 1553, 1093, 1398, 1554, 1095, 1399, 1555, 1096, 
       1400, 1556, 1097, 1504, 1213, 1098, 1505, 1214, 1099, 1506, 1215, 1100,
        1401, 1557, 1101, 1402, 1558, 1102, 1403, 1559, 1103, 1404, 1560, 
       1104, 765, 1105, 1507, 1216, 1106, 1508, 1217, 1107}], 
      Line3DBox[{1109, 1405, 1561, 1108, 1406, 1562, 1110, 1407, 1563, 1111, 
       1408, 1564, 1112, 1409, 1565, 1113, 773, 1114, 1509, 1218, 1115, 1410, 
       1566, 1116, 1411, 1567, 1117, 1412, 1568, 1118, 1413, 1569, 1119, 1414,
        1570, 1120, 780, 1121, 1510, 1219, 1122}], 
      Line3DBox[{1136, 1237, 815, 1135, 1581, 1425, 1134, 1580, 1424, 1133, 
       1579, 1423, 1132, 1578, 1422, 1131, 1577, 1421, 1130, 1576, 1420, 1129,
        788, 1128, 1575, 1419, 1127, 1574, 1418, 1126, 1573, 1417, 1125, 1572,
        1416, 1124, 1571, 1415, 1123, 814, 1235, 1236}]}, {
      Line3DBox[{434, 626, 1440, 435, 639, 461, 1514, 653, 475, 1519, 667, 
       489, 1525, 678, 500, 1531, 688, 511, 1539, 699, 522, 709, 1476, 533, 
       719, 1484, 545, 1549, 730, 557, 1551, 741, 571, 1554, 755, 585, 1562, 
       769, 599, 1571, 783, 613}], 
      Line3DBox[{436, 627, 1441, 437, 640, 1451, 462, 654, 476, 1520, 668, 
       490, 1526, 679, 501, 1532, 689, 512, 1540, 700, 523, 710, 1477, 534, 
       720, 1485, 546, 731, 1491, 558, 1552, 742, 572, 1555, 756, 586, 1563, 
       770, 600, 1572, 784, 614}], 
      Line3DBox[{438, 628, 1442, 439, 641, 1452, 463, 655, 1461, 477, 669, 
       491, 1527, 866, 867, 502, 1533, 690, 513, 1541, 882, 883, 524, 711, 
       1478, 535, 721, 1486, 547, 732, 1492, 559, 743, 1497, 573, 1556, 757, 
       587, 1564, 771, 601, 1573, 785, 615}], 
      Line3DBox[{440, 629, 1443, 441, 642, 1453, 464, 656, 1462, 478, 863, 
       1595, 864, 865, 869, 795, 868, 796, 826, 1585, 823, 824, 881, 1598, 
       885, 800, 884, 801, 841, 839, 840, 1479, 536, 896, 897, 1487, 548, 733,
        1493, 560, 744, 1498, 574, 758, 1504, 588, 1565, 772, 602, 1574, 786, 
       616}], Line3DBox[{442, 630, 1444, 443, 643, 1454, 465, 657, 1463, 479, 
       930, 1603, 931, 932, 933, 934, 1584, 825, 822, 876, 878, 879, 877, 798,
        834, 1588, 832, 838, 833, 891, 893, 894, 892, 803, 1480, 820, 899, 
       900, 898, 806, 854, 852, 1591, 853, 561, 745, 1499, 575, 759, 1505, 
       589, 773, 603, 1575, 787, 617}], 
      Line3DBox[{444, 631, 1445, 445, 644, 1455, 466, 658, 1464, 480, 870, 
       1596, 871, 872, 874, 875, 873, 797, 830, 828, 1587, 831, 829, 886, 888,
        889, 887, 802, 844, 842, 847, 843, 901, 902, 903, 821, 1583, 807, 857,
        855, 929, 1602, 856, 562, 746, 1500, 576, 760, 1506, 590, 774, 1509, 
       604, 788, 618}], 
      Line3DBox[{8, 955, 23, 969, 38, 984, 53, 999, 68, 1014, 276, 83, 1029, 
       333, 98, 1044, 289, 113, 351, 1302, 128, 307, 1263, 143, 365, 1309, 
       158, 1087, 173, 1100, 188, 1115, 203, 1129, 218}], 
      Line3DBox[{446, 632, 447, 1512, 645, 467, 1515, 659, 481, 935, 1604, 
       670, 492, 827, 1586, 680, 503, 799, 1582, 819, 906, 691, 514, 907, 908,
        890, 701, 525, 804, 848, 916, 712, 537, 917, 918, 904, 1589, 722, 549,
        809, 859, 925, 734, 563, 943, 944, 942, 1593, 747, 577, 1557, 761, 
       591, 1566, 775, 605, 1576, 789, 619}], 
      Line3DBox[{448, 633, 1446, 449, 646, 468, 1516, 660, 482, 1521, 671, 
       493, 880, 1597, 681, 504, 909, 910, 836, 837, 692, 515, 1601, 911, 912,
        846, 913, 702, 526, 914, 915, 895, 713, 1599, 538, 808, 858, 922, 723,
        550, 923, 924, 905, 1592, 735, 564, 941, 1605, 748, 578, 1558, 762, 
       592, 1567, 776, 606, 1577, 790, 620}], 
      Line3DBox[{450, 634, 1447, 451, 647, 1456, 469, 1517, 661, 483, 1522, 
       672, 494, 936, 682, 505, 1534, 835, 693, 516, 1542, 845, 703, 527, 919,
        805, 851, 920, 921, 1590, 539, 940, 850, 939, 724, 1600, 551, 926, 
       810, 862, 927, 928, 565, 947, 861, 946, 1594, 749, 579, 1559, 763, 593,
        1568, 777, 607, 1578, 791, 621}], 
      Line3DBox[{452, 635, 1448, 453, 648, 1457, 470, 662, 1465, 484, 1523, 
       673, 495, 1528, 683, 506, 1535, 694, 517, 1543, 937, 704, 528, 849, 
       714, 1607, 540, 938, 725, 1606, 552, 860, 736, 1608, 566, 945, 750, 
       580, 1560, 764, 594, 1569, 778, 608, 1579, 792, 622}], 
      Line3DBox[{454, 636, 1449, 455, 649, 1458, 471, 663, 1466, 485, 674, 
       1469, 496, 1529, 684, 507, 1536, 695, 518, 1544, 705, 529, 715, 1481, 
       541, 726, 1488, 553, 737, 1494, 567, 751, 1501, 581, 765, 595, 1570, 
       779, 609, 1580, 793, 623}], 
      Line3DBox[{456, 637, 1450, 457, 650, 1459, 472, 664, 1467, 486, 675, 
       1470, 497, 685, 1472, 508, 1537, 696, 519, 1545, 706, 530, 716, 1482, 
       542, 727, 1489, 554, 738, 1495, 568, 752, 1502, 582, 766, 1507, 596, 
       780, 610, 1581, 794, 624}], 
      Line3DBox[{458, 812, 813, 459, 651, 1460, 473, 665, 1468, 487, 676, 
       1471, 498, 686, 1473, 509, 697, 1474, 520, 707, 1475, 531, 717, 1483, 
       543, 728, 1490, 555, 739, 1496, 569, 753, 1503, 583, 767, 1508, 597, 
       781, 1510, 611, 815, 816, 817}], 
      Line3DBox[{612, 782, 814, 598, 768, 1561, 584, 754, 1553, 570, 740, 
       1550, 556, 729, 1548, 544, 718, 1547, 532, 708, 1546, 521, 698, 1538, 
       510, 687, 1530, 499, 677, 1524, 488, 666, 1518, 474, 652, 1513, 460, 
       638, 1511, 433, 625, 811, 818}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0fHlYTd37fkUDIlJEoUJKClEaz6OBRHNKKqSBIk0kodFYylCaVFIJjUrz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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"f(x,y)\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.3931571590231647`*^9, 3.3931571909390574`*^9}, {
  3.3931572225845613`*^9, 3.393157250554781*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{616, 750},
WindowMargins->{{18, Automatic}, {Automatic, 23}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 114, 2, 73, "Title"],
Cell[707, 27, 135, 2, 36, "Subtitle"],
Cell[845, 31, 148, 2, 29, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1018, 37, 149, 2, 75, "Section"],
Cell[CellGroupData[{
Cell[1192, 43, 192, 3, 37, "Subsection"],
Cell[CellGroupData[{
Cell[1409, 50, 211, 3, 27, "Subsubsection"],
Cell[1623, 55, 342, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[1990, 66, 543, 12, 62, "Input"],
Cell[2536, 80, 1374, 44, 79, "Output"]
}, Open  ]],
Cell[3925, 127, 238, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[4188, 137, 417, 8, 62, "Input"],
Cell[4608, 147, 210, 4, 40, "Output"],
Cell[4821, 153, 207, 4, 40, "Output"]
}, Open  ]],
Cell[5043, 160, 242, 8, 30, "Text"],
Cell[CellGroupData[{
Cell[5310, 172, 287, 8, 41, "Input"],
Cell[5600, 182, 405, 7, 40, "Output"]
}, Open  ]],
Cell[6020, 192, 218, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[6263, 202, 61, 1, 41, "Input"],
Cell[6327, 205, 182, 3, 55, "Output"]
}, Open  ]],
Cell[6524, 211, 271, 8, 48, "Text"],
Cell[CellGroupData[{
Cell[6820, 223, 120, 2, 41, "Input"],
Cell[6943, 227, 145, 2, 40, "Output"]
}, Open  ]],
Cell[7103, 232, 156, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[7284, 238, 391, 10, 62, "Input"],
Cell[7678, 250, 161, 3, 55, "Output"],
Cell[7842, 255, 155, 2, 40, "Output"]
}, Open  ]],
Cell[8012, 260, 208, 6, 30, "Text"],
Cell[CellGroupData[{
Cell[8245, 270, 133, 2, 41, "Input"],
Cell[8381, 274, 140, 3, 55, "Output"]
}, Open  ]],
Cell[8536, 280, 232, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[8793, 289, 250, 4, 62, "Input"],
Cell[9046, 295, 178, 5, 64, "Output"],
Cell[9227, 302, 136, 2, 40, "Output"]
}, Open  ]],
Cell[9378, 307, 377, 9, 48, "Text"],
Cell[CellGroupData[{
Cell[9780, 320, 271, 6, 49, "Input"],
Cell[10054, 328, 151, 2, 40, "Output"]
}, Open  ]],
Cell[10220, 333, 234, 6, 29, "Text"],
Cell[CellGroupData[{
Cell[10479, 343, 647, 16, 102, "Input"],
Cell[11129, 361, 129, 4, 64, "Output"],
Cell[11261, 367, 129, 4, 64, "Output"],
Cell[11393, 373, 129, 4, 64, "Output"],
Cell[11525, 379, 128, 4, 64, "Output"]
}, Open  ]],
Cell[11668, 386, 438, 13, 48, "Text"],
Cell[CellGroupData[{
Cell[12131, 403, 535, 12, 102, "Input"],
Cell[12669, 417, 117, 2, 40, "Output"],
Cell[12789, 421, 141, 3, 40, "Output"],
Cell[12933, 426, 177, 5, 80, "Output"],
Cell[13113, 433, 137, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13299, 441, 179, 3, 27, "Subsubsection"],
Cell[13481, 446, 517, 13, 67, "Text"],
Cell[CellGroupData[{
Cell[14023, 463, 942, 23, 82, "Input"],
Cell[14968, 488, 1321, 44, 79, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16326, 537, 346, 8, 82, "Input"],
Cell[16675, 547, 123, 2, 40, "Output"],
Cell[16801, 551, 136, 2, 40, "Output"],
Cell[16940, 555, 137, 2, 40, "Output"]
}, Open  ]],
Cell[17092, 560, 248, 7, 48, "Text"],
Cell[17343, 569, 1730, 48, 162, "Input"],
Cell[19076, 619, 362, 7, 65, "Text"],
Cell[CellGroupData[{
Cell[19463, 630, 502, 10, 102, "Input"],
Cell[19968, 642, 173, 2, 40, "Output"],
Cell[20144, 646, 177, 2, 40, "Output"],
Cell[20324, 650, 189, 2, 40, "Output"],
Cell[20516, 654, 187, 2, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20752, 662, 189, 3, 27, "Subsubsection"],
Cell[20944, 667, 405, 9, 65, "Text"],
Cell[CellGroupData[{
Cell[21374, 680, 1338, 33, 142, "Input"],
Cell[22715, 715, 151, 2, 40, "Output"],
Cell[22869, 719, 160, 2, 40, "Output"]
}, Open  ]],
Cell[23044, 724, 290, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[23359, 735, 545, 13, 82, "Input"],
Cell[23907, 750, 267, 8, 80, "Output"],
Cell[24177, 760, 195, 5, 40, "Output"],
Cell[24375, 767, 202, 5, 40, "Output"]
}, Open  ]],
Cell[24592, 775, 215, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[24832, 784, 1461, 31, 82, "Input"],
Cell[26296, 817, 17827, 300, 257, 12941, 218, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[44138, 1120, 139, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[44302, 1126, 1536, 32, 102, "Input"],
Cell[45841, 1160, 17809, 300, 238, 13130, 221, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63699, 1466, 218, 3, 27, "Subsubsection"],
Cell[63920, 1471, 370, 12, 48, "Text"],
Cell[CellGroupData[{
Cell[64315, 1487, 133, 3, 41, "Input"],
Cell[64451, 1492, 296, 6, 40, "Output"]
}, Open  ]],
Cell[64762, 1501, 314, 9, 49, "Text"],
Cell[CellGroupData[{
Cell[65101, 1514, 264, 7, 41, "Input"],
Cell[65368, 1523, 276, 5, 55, "Output"]
}, Open  ]],
Cell[65659, 1531, 442, 13, 48, "Text"],
Cell[CellGroupData[{
Cell[66126, 1548, 946, 26, 82, "Input"],
Cell[67077, 1577, 212, 4, 55, "Output"],
Cell[67292, 1583, 439, 11, 55, "Output"],
Cell[67734, 1596, 192, 3, 40, "Output"]
}, Open  ]],
Cell[67941, 1602, 235, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[68201, 1612, 412, 12, 62, "Input"],
Cell[68616, 1626, 140, 2, 40, "Output"]
}, Open  ]],
Cell[68771, 1631, 1023, 36, 119, "Text"],
Cell[CellGroupData[{
Cell[69819, 1671, 539, 15, 62, "Input"],
Cell[70361, 1688, 192, 4, 55, "Output"]
}, Open  ]],
Cell[70568, 1695, 653, 22, 102, "Text"],
Cell[CellGroupData[{
Cell[71246, 1721, 523, 16, 65, "Input"],
Cell[71772, 1739, 309, 8, 55, "Output"]
}, Open  ]],
Cell[72096, 1750, 257, 8, 47, "Text"],
Cell[CellGroupData[{
Cell[72378, 1762, 526, 13, 82, "Input"],
Cell[72907, 1777, 189, 4, 55, "Output"],
Cell[73099, 1783, 350, 11, 55, "Output"],
Cell[73452, 1796, 310, 8, 55, "Output"]
}, Open  ]],
Cell[73777, 1807, 194, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[73996, 1816, 496, 11, 62, "Input"],
Cell[74495, 1829, 160, 3, 55, "Output"],
Cell[74658, 1834, 162, 3, 55, "Output"]
}, Open  ]],
Cell[74835, 1840, 407, 9, 66, "Text"],
Cell[75245, 1851, 577, 17, 41, "Input"],
Cell[75825, 1870, 156, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[76006, 1876, 251, 6, 41, "Input"],
Cell[76260, 1884, 542, 15, 55, "Output"]
}, Open  ]],
Cell[76817, 1902, 239, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[77081, 1912, 299, 7, 41, "Input"],
Cell[77383, 1921, 188, 3, 40, "Output"]
}, Open  ]],
Cell[77586, 1927, 344, 7, 65, "Text"],
Cell[CellGroupData[{
Cell[77955, 1938, 843, 24, 108, "Input"],
Cell[78801, 1964, 214, 3, 40, "Output"],
Cell[79018, 1969, 237, 4, 55, "Output"],
Cell[79258, 1975, 249, 5, 64, "Output"],
Cell[79510, 1982, 232, 3, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79815, 1993, 188, 3, 75, "Section"],
Cell[CellGroupData[{
Cell[80028, 2000, 185, 3, 37, "Subsection"],
Cell[80216, 2005, 430, 10, 65, "Text"],
Cell[80649, 2017, 160, 3, 41, "Input",
 Evaluatable->False],
Cell[80812, 2022, 179, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[81016, 2030, 194, 5, 41, "Input"],
Cell[81213, 2037, 1207, 28, 52, "Output"]
}, Open  ]],
Cell[82435, 2068, 146, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[82606, 2074, 286, 6, 62, "Input"],
Cell[82895, 2082, 533, 8, 40, "Output"],
Cell[83431, 2092, 602, 11, 40, "Output"]
}, Open  ]],
Cell[84048, 2106, 447, 12, 66, "Text"],
Cell[CellGroupData[{
Cell[84520, 2122, 909, 26, 122, "Input"],
Cell[85432, 2150, 3126, 77, 258, 1588, 51, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88607, 2233, 182, 3, 37, "Subsection"],
Cell[88792, 2238, 341, 8, 47, "Text"],
Cell[CellGroupData[{
Cell[89158, 2250, 217, 5, 41, "Input"],
Cell[89378, 2257, 794, 16, 40, "Output"]
}, Open  ]],
Cell[90187, 2276, 132, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[90344, 2282, 328, 7, 62, "Input"],
Cell[90675, 2291, 604, 9, 40, "Output"],
Cell[91282, 2302, 663, 11, 40, "Output"]
}, Open  ]],
Cell[91960, 2316, 471, 16, 67, "Text"],
Cell[92434, 2334, 694, 20, 82, "Input"],
Cell[93131, 2356, 368, 9, 48, "Text"],
Cell[93502, 2367, 230, 5, 62, "Input"],
Cell[93735, 2374, 286, 7, 48, "Text"],
Cell[CellGroupData[{
Cell[94046, 2385, 575, 15, 41, "Input"],
Cell[94624, 2402, 2285, 44, 154, "Output"]
}, Open  ]],
Cell[96924, 2449, 578, 15, 91, "Text"],
Cell[CellGroupData[{
Cell[97527, 2468, 197, 4, 41, "Input"],
Cell[97727, 2474, 567, 13, 60, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98343, 2493, 179, 3, 37, "Subsection"],
Cell[98525, 2498, 378, 10, 67, "Text"],
Cell[CellGroupData[{
Cell[98928, 2512, 822, 14, 41, "Input"],
Cell[99753, 2528, 827, 20, 58, "Output"]
}, Open  ]],
Cell[100595, 2551, 373, 13, 48, "Text"],
Cell[CellGroupData[{
Cell[100993, 2568, 814, 16, 41, "Input"],
Cell[101810, 2586, 706, 19, 58, "Output"]
}, Open  ]],
Cell[102531, 2608, 870, 28, 83, "Text"],
Cell[CellGroupData[{
Cell[103426, 2640, 862, 16, 62, "Input"],
Cell[104291, 2658, 789, 22, 65, "Output"],
Cell[105083, 2682, 547, 12, 58, "Output"]
}, Open  ]],
Cell[105645, 2697, 220, 7, 29, "Text"],
Cell[CellGroupData[{
Cell[105890, 2708, 194, 5, 41, "Input"],
Cell[106087, 2715, 498, 11, 58, "Output"]
}, Open  ]],
Cell[106600, 2729, 182, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[106807, 2737, 331, 7, 62, "Input"],
Cell[107141, 2746, 332, 5, 40, "Output"],
Cell[107476, 2753, 330, 5, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107867, 2765, 183, 3, 75, "Section"],
Cell[CellGroupData[{
Cell[108075, 2772, 177, 3, 37, "Subsection"],
Cell[108255, 2777, 294, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[108574, 2788, 298, 8, 41, "Input"],
Cell[108875, 2798, 993, 23, 48, "Output"]
}, Open  ]],
Cell[109883, 2824, 214, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[110122, 2833, 439, 11, 62, "Input"],
Cell[110564, 2846, 357, 6, 55, "Output"],
Cell[110924, 2854, 431, 9, 55, "Output"]
}, Open  ]],
Cell[111370, 2866, 274, 8, 47, "Text"],
Cell[CellGroupData[{
Cell[111669, 2878, 1202, 32, 122, "Input"],
Cell[112874, 2912, 4373, 83, 144, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117296, 3001, 194, 3, 37, "Subsection"],
Cell[117493, 3006, 224, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[117742, 3015, 583, 14, 82, "Input"],
Cell[118328, 3031, 594, 16, 77, "Output"],
Cell[118925, 3049, 282, 4, 40, "Output"],
Cell[119210, 3055, 308, 5, 40, "Output"]
}, Open  ]],
Cell[119533, 3063, 200, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[119758, 3072, 579, 15, 62, "Input"],
Cell[120340, 3089, 12671, 214, 269, "Output"]
}, Open  ]],
Cell[133026, 3306, 799, 18, 105, "Text"],
Cell[CellGroupData[{
Cell[133850, 3328, 2473, 61, 224, "Input"],
Cell[136326, 3391, 80977, 1512, 248, "Output"]
}, Open  ]],
Cell[217318, 4906, 250, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[217593, 4917, 400, 11, 41, "Input"],
Cell[217996, 4930, 640, 18, 55, "Output"]
}, Open  ]],
Cell[218651, 4951, 292, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[218968, 4961, 380, 9, 41, "Input"],
Cell[219351, 4972, 1491, 31, 126, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[220891, 5009, 187, 3, 37, "Subsection"],
Cell[221081, 5014, 490, 15, 65, "Text"],
Cell[CellGroupData[{
Cell[221596, 5033, 591, 15, 82, "Input"],
Cell[222190, 5050, 733, 19, 77, "Output"]
}, Open  ]],
Cell[222938, 5072, 206, 7, 29, "Text"],
Cell[223147, 5081, 344, 8, 41, "Input",
 Evaluatable->False],
Cell[223496, 5092, 274, 8, 29, "Text"],
Cell[CellGroupData[{
Cell[223795, 5104, 621, 15, 62, "Input"],
Cell[224419, 5121, 9216, 160, 243, 4811, 86, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[233650, 5284, 306, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[233981, 5295, 740, 16, 82, "Input"],
Cell[234724, 5313, 535, 10, 50, "Output"],
Cell[235262, 5325, 704, 16, 49, "Output"],
Cell[235969, 5343, 542, 11, 49, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[236560, 5360, 185, 3, 37, "Subsection"],
Cell[236748, 5365, 652, 19, 49, "Text"],
Cell[CellGroupData[{
Cell[237425, 5388, 508, 12, 82, "Input"],
Cell[237936, 5402, 271, 6, 62, "Output"],
Cell[238210, 5410, 168, 2, 40, "Output"],
Cell[238381, 5414, 191, 3, 40, "Output"]
}, Open  ]],
Cell[238587, 5420, 208, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[238820, 5429, 755, 17, 82, "Input"],
Cell[239578, 5448, 2383, 44, 241, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[242010, 5498, 185, 3, 37, "Subsection"],
Cell[242198, 5503, 632, 22, 55, "Text"],
Cell[CellGroupData[{
Cell[242855, 5529, 840, 22, 109, "Input"],
Cell[243698, 5553, 572, 16, 71, "Output"],
Cell[244273, 5571, 171, 2, 40, "Output"],
Cell[244447, 5575, 222, 4, 58, "Output"],
Cell[244672, 5581, 204, 4, 59, "Output"]
}, Open  ]],
Cell[244891, 5588, 200, 5, 29, "Text"],
Cell[CellGroupData[{
Cell[245116, 5597, 931, 27, 114, "Input"],
Cell[246050, 5626, 743, 24, 82, "Output"],
Cell[246796, 5652, 163, 2, 40, "Output"],
Cell[246962, 5656, 232, 5, 40, "Output"],
Cell[247197, 5663, 161, 2, 40, "Output"]
}, Open  ]],
Cell[247373, 5668, 320, 12, 29, "Text"],
Cell[CellGroupData[{
Cell[247718, 5684, 1478, 40, 127, "Input"],
Cell[249199, 5726, 46267, 779, 248, "Output"]
}, Open  ]],
Cell[295481, 6508, 298, 7, 47, "Text"],
Cell[CellGroupData[{
Cell[295804, 6519, 325, 8, 43, "Input"],
Cell[296132, 6529, 193, 3, 40, "Output"]
}, Open  ]],
Cell[296340, 6535, 334, 11, 47, "Text"],
Cell[CellGroupData[{
Cell[296699, 6550, 324, 7, 41, "Input"],
Cell[297026, 6559, 179, 2, 40, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[297266, 6568, 186, 3, 75, "Section"],
Cell[297455, 6573, 589, 11, 83, "Text"],
Cell[CellGroupData[{
Cell[298069, 6588, 196, 3, 37, "Subsection"],
Cell[298268, 6593, 278, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[298571, 6603, 1169, 33, 130, "Input"],
Cell[299743, 6638, 1222, 35, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301002, 6678, 1738, 53, 153, "Input"],
Cell[302743, 6733, 123, 3, 40, "Output"],
Cell[302869, 6738, 181, 5, 43, "Output"],
Cell[303053, 6745, 399, 11, 43, "Output"]
}, Open  ]],
Cell[303467, 6759, 245, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[303737, 6768, 1586, 43, 191, "Input",
 CellID->20649],
Cell[305326, 6813, 138777, 2261, 295, 88870, 1441, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

